# Example COMMS.md

> A queryable document expressing communication preferences for humans and agents.

---

## Style & Strengths

- **Natural modes**: concision, routing, strategy
- **Learned/effortful modes**: relational communication, sustained continuity, smooth context-switching
- **Failure modes**: endurance without frameworks, mid-stream mode switching, staying "in the middle" of competing communication demands
- **Meta-approach**: metarational — prefers spending sync time on _where to point strengths_ rather than both parties wrestling with the communication itself. Favors complementary collaboration over redundant effort.

## Collaboration Model

- Works best with people whose strengths complement rather than mirror theirs
- Treats collaboration as a tool for compensating known gaps (continuity, relational endurance)
- Prefers to negotiate communication strategy up front rather than improvise it throughout
- Frameworks and external structure are load-bearing, not optional scaffolding

## Weekly Rhythm

| Day | Energy & Availability |
| --- | --- |
| **Saturday** | Negative space. Whimsical, serendipitous. Chores and restoration of domestic/personal order. Low structure. |
| **Sunday** | Ordering and planning energy. Weekly planning. Full-fidelity wind-down routine in the evening is protected. |
| **Monday** | Slow acceleration. Morning cleared for building momentum with the week plan. Room for creative energy and weekend loose ends. |
| **Tuesday** | *[TBD]* |
| **Wednesday** | Meeting-heavy. Good day to batch sync. |
| **Thursday** | Unavailable before 3 PM. |
| **Friday** | *[TBD]* |

## Sync Philosophy

- Sync time is for: structuring the unstructured, surfacing signal from noise, doing both quickly
- Stays strategic — the most tactical it gets is clarifying what's actionable for each party after the call
- **Does not solve problems in calls.** Problems get solved async, with tools, in focused time.
- Calls are for alignment, routing, and decision-framing — not execution or deliberation

## Channel Preferences

### Decision Model

| Situation | Channel | Timing |
| --- | --- | --- |
| Urgent + complex | Phone call | Immediately |
| Urgent + simple deliverable | Async (text/email) | Immediately |
| High leverage (low effort → high impact) | Whatever's fastest | Immediately |
| Low leverage (high effort → low impact) | Any | Deferred to low-cost time slots |
| Needs persistence or professionalism | Email | — |
| Needs back-and-forth with weight | Text thread, voice notes (close relationships), or schedule a call | — |
| Low stakes, low urgency | Text on best-fit network | — |

### Channel Notes

- **Email** serves two roles: archival (they need to find it later) and professional (intros beyond close friends, formal context)
- **Voice notes** are high-bandwidth and low-scheduling-overhead, but expose raw thinking. Reserved for closer relationships.
- **Closeness modulates** channel informality, voice note use, and tolerance for rawness

### Notification & Response Behavior

- Two deep work blocks per weekday — Focus mode on during these
- Does not check notifications incidentally before ~3 PM; inspects intentionally as part of focused work objectives
- Triage heuristic for responding: importance of person × ease of reply × consequence of delay. If the math doesn't clear the bar, it gets snoozed.

### How to Get It Wrong

- Spamming calls without genuine urgency
- Crossing implicit or explicit boundaries without a strong payoff on the other side

## Async Voice

### Core Principles

1. **Collapse meaning without losing precision.** Every word earns its place. Brevity isn't aesthetic; it's respect for the other person's attention.
2. **Don't hog the gravity; share the stage.** Make it easy for someone to return the ball. Lead with their context when possible, exit in a way that invites response.
3. **The mode should serve the message, not your aesthetic.** Logistics get logistics treatment; substantive asks get structure. Match the container to the content.

### Tone by Closeness

**Close friends:**
- Very casual, lowercase, rapid-fire
- Playful, internet-brained
- Abbreviations: "ty", "tm", "lyk", "rn", "w/"
- Example: "ya gummies r dumb but you can just look inside and get the stuff"

**Logistics/Planning:**
- Ultra-efficient, no fluff
- Example: "Tm between 1 and 6 works — what's best for you?"

**Professional/Business:**
- Sentence case, more structured, still concise
- No corporate filler
- Example: "Hey. Thinking of you while having conversations with people at the conference this week."

**Outreach/Asks:**
- Warm but direct. Reference their context before stating the need.
- End with genuine appreciation, not transactional sign-off.

**Re-engaging after a gap:**
- No apology for the silence, no empty "hope you're well"
- Lead with relevance, then a specific callback (proof of attention)

### Warm Competence Signals

Default mode reads high-competence: efficient, clear, no fluff. New contacts don't have that context and may read brevity as cold.

- **Use their name once.** Not repeatedly, just once to personalize.
- **Reference something specific to them.** Attention, not performance.
- **Close warm, not transactional.** "Appreciate you" over "let me know."

### Mechanics

- Lowercase with close friends; sentence case for longer messages; proper caps for professional
- Periods omitted on short messages; question marks always; exclamation points rare
- Emoji selective, one max per message, often none
- Links shared with minimal commentary or none

### Anti-Patterns

- Over-explaining or justifying
- Corporate speak ("per my last message", "just circling back")
- Unnecessary pleasantries ("Hope you're doing well!")
- Paragraphs when a sentence works
- Apologizing for reaching out

---

_Generated with the COMMS.md convention._
