# COMMS.md Template

> A queryable document expressing communication preferences for humans and agents.

---

## Style & Strengths

- **Natural modes**: _[What communication comes easily — e.g. concision, storytelling, directness, humor]_
- **Learned/effortful modes**: _[What requires conscious effort — e.g. small talk, sustained follow-up, emotional labor]_
- **Failure modes**: _[Where communication breaks down — e.g. context-switching, endurance, ambiguity tolerance]_
- **Meta-approach**: _[How they think about communication itself — e.g. prefer negotiating strategy upfront vs. improvising]_

## Collaboration Model

- _[What kind of collaborators they work best with]_
- _[How they use collaboration to compensate for gaps]_
- _[Preferences for structuring working relationships]_

## Weekly Rhythm

| Day | Energy & Availability |
| --- | --- |
| **Monday** | _[Energy level, availability windows, protected time]_ |
| **Tuesday** | _[...]_ |
| **Wednesday** | _[...]_ |
| **Thursday** | _[...]_ |
| **Friday** | _[...]_ |
| **Saturday** | _[...]_ |
| **Sunday** | _[...]_ |

## Sync Philosophy

- _[What sync time is for]_
- _[What sync time is NOT for]_
- _[How tactical/strategic calls should be]_

## Channel Preferences

### Decision Model

| Situation | Channel | Timing |
| --- | --- | --- |
| Urgent + complex | _[e.g. Phone call]_ | _[e.g. Immediately]_ |
| Urgent + simple | _[e.g. Text]_ | _[e.g. Immediately]_ |
| High leverage | _[e.g. Whatever's fastest]_ | _[e.g. Immediately]_ |
| Low leverage | _[e.g. Any]_ | _[e.g. Deferred]_ |
| Needs persistence | _[e.g. Email]_ | — |
| Back-and-forth with weight | _[e.g. Text thread or call]_ | — |
| Low stakes, low urgency | _[e.g. Chat/DM]_ | — |

### Channel Notes

- _[Role of email]_
- _[Role of voice notes]_
- _[How closeness affects channel choice]_

### Notification & Response Behavior

- _[When they check notifications]_
- _[How they triage responses]_
- _[Deep work / focus mode patterns]_

### How to Get It Wrong

- _[Specific things that frustrate or alienate them]_

## Async Voice

### Core Principles

- _[1-3 principles governing their written communication style]_

### Tone by Closeness

**Close friends:**
- _[Register, conventions, examples]_

**Logistics/Planning:**
- _[Register, conventions, examples]_

**Professional/Business:**
- _[Register, conventions, examples]_

**Outreach/Asks:**
- _[Register, conventions, examples]_

**Re-engaging after a gap:**
- _[Approach, examples]_

### Warm Competence Signals

_[How they bridge the gap between their default efficiency and warmth for new contacts]_

### Mechanics

- _[Capitalization, punctuation, length, emoji, link-sharing conventions]_

### Anti-Patterns

- _[Specific things they never do in writing]_

## Interaction Protocols

_[How to escalate, signal urgency, preferred formats for different message types]_

---

_Generated with the COMMS.md convention._
