---
name: common-core-ela-checker
description: Common Core State Standards ELA alignment checker. Analyzes lesson plans, unit plans, and assessments against CCSS ELA standards for K-12. Use when reviewing lesson plans for standards alignment, creating curriculum maps, designing assessments, or ensuring coverage of reading, writing, speaking/listening, and language standards.
---

# Common Core ELA Standards Checker

Align lesson and unit plans with Common Core State Standards for English Language Arts (K-12).

## Key Features

### Standards Alignment
- Check lessons against CCSS ELA standards
- Identify which standards are addressed
- Suggest missing standards coverage
- Verify grade-level appropriateness

### Standards Categories
- **Reading**: Literature, Informational Text, Foundational Skills (K-5)
- **Writing**: Text Types, Production, Research
- **Speaking & Listening**: Comprehension, Presentation
- **Language**: Conventions, Knowledge, Vocabulary

### Analysis Types
- Single lesson alignment check
- Unit plan coverage analysis
- Assessment standards mapping
- Curriculum gap identification

## Quick Commands

**Check lesson**: "Analyze this lesson plan for CCSS alignment"

**Review unit**: "Check this unit plan against grade 8 ELA standards"

**Suggest standards**: "What CCSS standards should I include for a poetry unit?"

**Gap analysis**: "What standards are missing from this curriculum?"

## References

- [Common Core ELA Standards](references/common-core-ela-standards.pdf) - Complete K-12 standards document
- [Reading Standards](references/reading-standards.md) - Literature and informational text
- [Writing Standards](references/writing-standards.md) - Text types and purposes
- [Speaking & Listening](references/speaking-listening.md) - Comprehension and collaboration
- [Language Standards](references/language-standards.md) - Conventions and vocabulary
