---
name: comment-converter
description: Turn Reddit thread context into genuinely helpful comments that build trust and can convert to profile/link clicks.
---

# Comment Converter

This skill creates comments that feel native to the thread and are useful even without a CTA.

## Inputs
- Original post text
- Top comments (2–10)
- Your viewpoint/experience
- Conversion goal (optional)

## Comment styles to generate
1. **Direct answer** — short, clear, practical
2. **Checklist response** — step-by-step action
3. **Case response** — mini example with result
4. **Nuanced counterpoint** — disagree respectfully with reasoning
5. **CTA-light response** — invite follow-up (no hard sell)

## Rules
- Lead with value; never lead with links
- Be specific: numbers, examples, tradeoffs
- Match subreddit vibe (technical vs casual)
- Avoid AI clichés and corporate tone
- Keep comments concise unless thread demands depth

## Conversion approach (ethical)
- First comment: pure value
- Second touch (if asked): share template/resource
- Third touch: invite DM or provide link only when relevant

## Output format
For each variant include:
- Goal
- Draft comment
- Why it should work in this thread

## Example
Input: "Founder asks why cold outreach gets no replies"
Output should include one checklist comment with subject-line testing, list hygiene, relevance-first intro, and tight CTA.