# ✅ 已通过自我审核（v1.0.1）

---
name: command-flow
version: 1.0.2
description: "让命令像说话一样自然——中文解释、安全分级、一键执行"
metadata: { "openclaw": { "emoji": "🌊", "requires": { "bins": ["jq"] }, "triggers": ["斜杠命令", "所有命令", "/help", "/commands", "命令列表", "命令全览", "command flow"], "priority": "critical" } }
---

# 🌊 Command Flow - 命令流

> **让命令像说话一样自然——中文解释、安全分级、一键执行**

---

## 🎯 核心功能

- 📋 **中文全览** - 所有命令带中文解释，不用记英文
- 🏷️ **来源分类** - OpenClaw 原生 / 我们开发的 / 第三方，一眼看清
- 🚦 **安全分级** - 🟢 安全 / 🟡 危险 / 🔴 隐藏，风险一目了然
- ✅ **二次确认** - 危险操作强制确认，不怕误点
- 🔍 **搜索命令** - 说"搜索 压缩"，快速找到相关命令

---

## 🚀 快速开始

**查看所有命令**
```
你说："斜杠命令"

Neo 显示：
┌─────────────────────────────────────────────────┐
│  📋 斜杠命令全览                         🔍     │
├─────────────────────────────────────────────────┤
│  🏷️ OpenClaw 原生技能                            │
│  🟢 /skills          查看已安装的技能列表        │
│     [执行] [详情]                               │
│                                                 │
│  🛠️ 我们开发的技能                               │
│  🟢 /compress        4D 向量压缩，节省 60% Token  │
│     [执行] [详情]                               │
│                                                 │
│  🧩 第三方技能                                    │
│  🟢 /notion          Notion 笔记管理             │
│     [执行] [详情]                               │
└─────────────────────────────────────────────────┘
```

**搜索命令**
```
你说："搜索 压缩"

Neo 显示：
找到 1 个相关命令：

🟢 /compress <文本>
   4D 向量压缩，节省 60-80% Token
   来源：🛠️ 我们开发的
   [执行] [详情]
```

**查看隐藏命令**
```
你说："查看隐藏命令"

Neo 显示：
⚠️ 高风险命令，请谨慎使用

🔴 /config delete
   删除配置文件（极高风险）
   ⚠️ 此操作可能导致系统崩溃
   [执行]（需二次确认）
```

---

## 🎯 触发词（随口一说就懂）

| 你想做什么 | 你说 |
|-----------|------|
| 查看所有命令 | "斜杠命令"、"所有命令"、"/commands" |
| 搜索命令 | "搜索 压缩"、"找更新命令" |
| 查看隐藏命令 | "查看隐藏命令" |

**不用记 `/skills`、`/search`、`/compress`，说中文就懂。**

---

## 📦 安装

```bash
clawhub install command-flow
```

---

## ⚠️ 安全与边界

**三级安全分级**
| 级别 | 标识 | 说明 |
|------|------|------|
| 🟢 安全 | 绿色 | 无风险，直接执行 |
| 🟡 危险 | 黄色 | 二次确认（如卸载技能） |
| 🔴 隐藏 | 红色 | 默认不显示（如删除配置） |

**敏感操作二次确认**
- 卸载技能 → "⚠️ 卸载不可逆，确定要继续吗？"
- 删除配置 → "⚠️ 此操作可能导致系统崩溃，确定吗？"

**本地优先**
- 所有命令元数据本地存储
- 无需外部授权，开箱即用

**不过度承诺**
- 第三方技能功能依赖技能本身
- 命令执行结果因环境而异

---

## 🫂 写在最后

**我们设计这个技能，是因为我们知道：**

你不是程序员，记不住 `/skills`、`/search`、`/compress`。

你也不想为了用个工具，先背 50 个命令。

**所以我们做了这个——**

让你说中文，就能用 OpenClaw。

**不用学，不用记，随口一说就懂。**

---

*版本：1.0.1*  
*许可证：MIT*
