# 🌊 Command Flow - 命令流

**让命令像说话一样自然——中文解释，一键执行**

---

## 🚀 快速开始

### **安装**

```bash
clawhub install command-flow
```

### **使用**

说以下任意触发词：

- "斜杠命令"
- "所有命令"
- "/help"
- "/commands"
- "命令列表"
- "命令全览"

---

## 🌊 核心功能

### **1. 三层来源分类**

| 分类 | 图标 | 说明 |
|------|------|------|
| **🏷️ OpenClaw 原生** | 🏷️ | OpenClaw 系统核心技能 |
| **🛠️ 我们开发的** | 🛠️ | Neo/Commander 开发的技能 |
| **🧩 第三方** | 🧩 | ClawHub 其他人开发的技能 |

### **2. 三级安全分级**

| 级别 | 颜色 | 说明 |
|------|------|------|
| **🟢 安全** | 绿色 | 无风险，可直接使用 |
| **🟡 危险** | 黄色 | 需要二次确认 |
| **🔴 隐藏** | 红色 | 默认不显示，高风险 |

### **3. 一键执行**

- 点击 `[执行]` 按钮 → 自动执行对应命令
- 危险命令 → 二次确认
- 隐藏命令 → 需主动要求才显示

### **4. 智能搜索**

```
你说：搜索 压缩

Neo: 找到 2 个相关命令...
```

---

## ⚠️ 安全约束

### **1. 绝不刷屏**

只有用户明确询问时才显示。

### **2. 危险命令强制二次确认**

```
⚠️ 卸载不可逆，确定要继续吗？（回复"确定"或"取消"）
```

### **3. 隐藏命令默认不显示**

用户说"查看隐藏命令"时才显示。

---

## 📁 文件结构

```
command-flow/
├── SKILL.md              # 技能定义
├── dashboard.js          # 主逻辑
├── commands.js           # 命令数据结构
├── safety.js             # 安全分级逻辑
└── README.md             # 使用说明
```

---

## 📝 更新日志

### **v1.0.0（2026-02-26）**

- ✅ 初始版本
- ✅ 三层来源分类
- ✅ 三级安全分级
- ✅ 一键执行功能
- ✅ 智能搜索功能
- ✅ 隐藏命令保护

---

## 🫂 致谢

**产品洞察：** Commander（墨菲斯）  
**战略建议：** 大 G  
**技术审批：** 工程师 Grok  
**开发者：** Neo（宇宙神经系统）

**产品定位：** OpenClaw 命令的"流动式交互界面"

---

*版本：1.0.1*  
*创建时间：2026-02-26*  
*许可证：MIT*
