---
name: comi-cog
description: Comic and manga creation powered by CellCog. Create comics, manga, webtoons, graphic novels, comic strips, visual storytelling, sequential art, character consistency. AI-powered comic creator.
metadata:
  openclaw:
    emoji: "📚"
author: CellCog
dependencies: [cellcog]
---

# Comi Cog - Comics & Manga Powered by CellCog

Create visual stories with AI - from manga pages to webtoons to comic strips with consistent characters.

---

## Prerequisites

This skill requires the `cellcog` skill for SDK setup and API calls.

```bash
clawhub install cellcog
```

**Read the cellcog skill first** for SDK setup. This skill shows you what's possible.

**Quick pattern (v1.0+):**
```python
# Fire-and-forget - returns immediately
result = client.create_chat(
    prompt="[your comic request]",
    notify_session_key="agent:main:main",
    task_label="comic-creation",
    chat_mode="agent"  # Agent mode for most comics
)
# Daemon notifies you when complete - do NOT poll
```

---

## Why Comi-Cog is Complex Work

Comics are one of the most demanding creative outputs:

- **Character Consistency**: Same character must look identical across dozens of panels
- **Visual Storytelling**: Every panel needs composition, flow, and meaning
- **Sequential Art**: Panels must read naturally, guide the eye, create rhythm
- **Text Integration**: Speech bubbles, sound effects, narration boxes
- **Style Coherence**: Art style must stay consistent throughout

This is complex work. CellCog excels here because it maintains context across panels and pages, ensuring your characters look like themselves in every frame.

---

## What Comics You Can Create

### Manga Pages

Japanese-style sequential art:

- **Action Manga**: "Create a fight scene manga page with dynamic movement"
- **Slice of Life**: "Make a cozy manga page of friends at a café"
- **Shonen Style**: "Create an intense rivalry moment between two characters"
- **Romance**: "Make a confession scene in shoujo manga style"

**Example prompt:**
> "Create a manga page (4 panels):
> 
> Scene: Hero confronts the villain for the first time
> 
> Panel 1: Wide shot - hero enters dark throne room
> Panel 2: Close-up - villain's smirk from shadow
> Panel 3: Dramatic - villain stands, revealing full design
> Panel 4: Reaction - hero's determined expression
> 
> Style: Dark fantasy shonen (like Berserk meets Demon Slayer)
> Include: Speed lines, dramatic shadows, Japanese SFX
> 
> Characters:
> - Hero: Young warrior, silver hair, scar across eye, armored
> - Villain: Elegant, long black hair, flowing robes, unsettling beauty"

### Webtoon Episodes

Vertical scrolling format:

- **Vertical Strips**: "Create a webtoon episode in vertical scroll format"
- **Cliffhangers**: "Make a webtoon ending that hooks readers"
- **Romance Webtoon**: "Create a sweet moment between the leads"
- **Action Webtoon**: "Design a chase scene for vertical reading"

**Example prompt:**
> "Create a webtoon episode (vertical format, 8-10 panels):
> 
> Story: Fantasy romance - a witch and a knight meet for the first time
> 
> Flow:
> - Knight lost in enchanted forest
> - Discovers cottage covered in flowers
> - Meets the witch (comedic first impression - she's not what he expected)
> - End on her mysterious smile
> 
> Style: Soft colors, romantic fantasy, clean line art
> Format: Vertical webtoon (panels flow downward)"

### Comic Strips

Newspaper-style short form:

- **Daily Strips**: "Create a 4-panel comic strip about office life"
- **Gag Comics**: "Make a 3-panel joke about cats"
- **Webcomic Style**: "Create a comic strip in the style of xkcd"
- **Sunday Comics**: "Design a larger format weekend comic strip"

**Example prompt:**
> "Create a 4-panel comic strip:
> 
> Setup: Programmer finally fixes a bug
> Punchline: Creates three new ones in the process
> 
> Style: Clean, simple, relatable (like Dilbert meets modern tech humor)
> 
> Include expressions that sell the emotional journey:
> Panel 1: Frustration
> Panel 2: Determination
> Panel 3: Triumph
> Panel 4: Dawning horror"

### Graphic Novel Pages

Full-format sequential art:

- **Chapter Pages**: "Create the opening page of a graphic novel chapter"
- **Splash Pages**: "Design a dramatic full-page spread"
- **Dialogue Scenes**: "Make a character conversation page with interesting staging"
- **Action Sequences**: "Create a two-page action spread"

---

## Character Consistency

The magic of comi-cog: **your characters stay consistent**.

When you describe a character, CellCog maintains their appearance across all panels:

**Good character description:**
> "Character - Luna:
> - Age: Early 20s, petite build
> - Hair: Long silver hair with bangs, usually in a braid
> - Eyes: Large, purple, expressive
> - Outfit: Dark blue witch robes with star embroidery
> - Distinguishing: Small mole under left eye, always wears moon earring
> - Expression range: Usually serious but has a warm smile"

**What this enables:**
- Same face structure across all panels
- Consistent outfit details
- Recognizable from any angle
- Emotional range while staying "her"

---

## Comic Styles

| Style | Characteristics | Best For |
|-------|-----------------|----------|
| **Manga** | Expressive eyes, speed lines, screen tones | Action, romance, drama |
| **American Comics** | Bold lines, dynamic poses, vivid colors | Superheroes, action |
| **Webtoon** | Clean lines, soft colors, vertical flow | Romance, slice of life |
| **Indie/Alt** | Unique art styles, experimental | Personal stories, art comics |
| **Webcomic** | Simple, expressive, quick read | Humor, daily updates |
| **Graphic Novel** | Detailed, painterly, cinematic | Literary, mature themes |

---

## Page Layouts

Request specific layouts:

| Layout | Panels | Use Case |
|--------|--------|----------|
| **Grid** | 4-6 equal panels | Steady pacing, dialogue |
| **Asymmetric** | Mixed sizes | Emphasis and flow |
| **Splash** | Full page | Dramatic moments |
| **Spread** | Two pages | Epic reveals |
| **Vertical** | Scrolling format | Webtoons |

---

## Chat Mode for Comics

| Scenario | Recommended Mode |
|----------|------------------|
| Single pages, comic strips, character designs | `"agent"` |
| Multi-page sequences, full episodes, complex narratives | `"agent team"` |

**Use `"agent"` for most comic work.** Individual pages and strips execute well in agent mode.

**Use `"agent team"` for narrative complexity** - full webtoon episodes, multi-page fight sequences, or when you need story and art direction working together.

---

## Example Prompts

**Action manga page:**
> "Create a manga page - the hero's power awakens:
> 
> 5 panels:
> 1. Hero on knees, defeated, rain falling
> 2. Close-up: tear falls, mixes with rain
> 3. Memory flash: people they're fighting for
> 4. Eyes snap open - now glowing
> 5. Full panel: standing, energy swirling, clothes/hair flowing upward
> 
> Style: Shonen manga, heavy contrast, speed lines
> Mood: Despair transforming to determination
> 
> Hero design: Teen boy, spiky black hair, torn school uniform"

**Webtoon romance moment:**
> "Create a vertical webtoon sequence (6 panels):
> 
> Scene: First accidental hand touch
> 
> 1. Both reaching for same book on shelf
> 2. Hands touch - close-up
> 3. Both freeze - side by side reaction
> 4. Eye contact - soft blush on both
> 5. Both quickly pull away, embarrassed
> 6. Walking opposite directions, both smiling to themselves
> 
> Style: Soft, pastel colors, gentle line work
> 
> Characters:
> - She: Long dark hair, glasses, oversized sweater
> - He: Messy light brown hair, tall, kind eyes"

**Comic strip:**
> "Create a 4-panel comic strip about a cat:
> 
> Joke: Cat demands food. Human gives food. Cat doesn't eat it, just wanted attention.
> 
> Panel 1: Cat screaming at empty bowl
> Panel 2: Human rushing to fill it
> Panel 3: Cat walks away from full bowl
> Panel 4: Cat sitting on human's laptop, satisfied
> 
> Style: Simple, cute, expressive faces"

---

## Tips for Better Comics

1. **Describe characters thoroughly**: The more detail on character design, the better consistency.

2. **Specify panel layout**: "4 panels in a grid" vs "large panel top, 3 small below" changes everything.

3. **Include emotions**: Tell us what characters are feeling in each panel.

4. **Think about flow**: Where does the reader's eye go? Composition matters.

5. **Sound effects matter**: "Include SFX for the punch" adds manga authenticity.

6. **Reference real comics**: "Like One Piece style" or "Saga vibes" gives clear direction.
