# Contributing to ComfyUI Skill

This skill teaches OpenClaw how to run ComfyUI workflows via the HTTP API and how to edit workflow JSON before running. Determine where the problem lies before reporting issues.

## Issue Reporting Guide

### Open an issue in this skill’s repository if

- The skill documentation (SKILL.md) is unclear or missing
- The run script (comfyui_run.py) fails in a way that is not a ComfyUI server/API issue
- You need help using this skill with OpenClaw
- The skill is missing instructions for a workflow pattern you need

### Open an issue at ComfyUI if

- The ComfyUI server crashes or returns errors for valid API payloads
- You found a bug in ComfyUI’s node execution or API
- You need a new feature in ComfyUI itself

### Check locally first

- ComfyUI server must be running on 127.0.0.1:8188 (or the host/port you use).
- Use `~/ComfyUI/venv/bin/python` (or your venv) when running the script; avoid bare `python` if it is not on PATH.

## Issue Report Template

```markdown
### Description
[Clear description of the bug or request]

### Reproduction Steps
1. [Step]
2. [Step]
3. [Observe error]

### Expected Behavior
[What you expected]

### Environment
- **Skill version:** [e.g. 1.0.0]
- **ComfyUI:** [version or commit]
- **Python:** [version]
- **OS:** [e.g. Ubuntu 22.04, macOS]
```

## Updating the Skill

- When ComfyUI’s API or workflow format changes, update SKILL.md and the run script.
- Keep the “If the server isn’t reachable” section in sync with current ComfyUI install/run instructions.
- Bump version when publishing a new release to ClawHub.
