---
name: comfyui-tts
description: "Generate speech audio using ComfyUI Qwen-TTS service. Invoke when user needs text-to-speech conversion or voice generation through ComfyUI."
metadata:
  {
    "openclaw":
      {
        "emoji": "🔊",
        "requires": { "bins": ["curl", "jq"] },
        "install": [],
      },
  }
---

# ComfyUI TTS Skill

Generate speech audio using ComfyUI's Qwen-TTS service. This skill allows you to convert text to speech through ComfyUI's API.

## Configuration

### Environment Variables

Set these environment variables to configure the ComfyUI connection:

```bash
export COMFYUI_HOST="localhost"      # ComfyUI server host
export COMFYUI_PORT="8188"           # ComfyUI server port
export COMFYUI_OUTPUT_DIR=""         # Optional: Custom output directory
```

## Usage

### Basic Text-to-Speech

Generate audio from text using default settings:

```bash
scripts/tts.sh "你好，世界"
```

### Advanced Options

Customize voice characteristics:

```bash
# Specify character and style
scripts/tts.sh "你好" --character "Girl" --style "Emotional"

# Change model size
scripts/tts.sh "你好" --model "3B"

# Specify output file
scripts/tts.sh "你好" --output "/path/to/output.wav"

# Combine options
scripts/tts.sh "你好，这是测试" \
  --character "Girl" \
  --style "Emotional" \
  --model "1.7B" \
  --output "~/audio/test.wav"
```

### Available Options

| Option | Description | Default |
|--------|-------------|---------|
| `--character` | Voice character (Girl/Boy/etc.) | "Girl" |
| `--style` | Speaking style (Emotional/Neutral/etc.) | "Emotional" |
| `--model` | Model size (0.5B/1.7B/3B) | "1.7B" |
| `--output` | Output file path | Auto-generated |
| `--temperature` | Generation temperature (0-1) | 0.9 |
| `--top-p` | Top-p sampling | 0.9 |
| `--top-k` | Top-k sampling | 50 |

## Workflow

The skill performs these steps:

1. **Construct Workflow**: Builds a ComfyUI workflow JSON with your text and settings
2. **Submit Job**: Sends the workflow to ComfyUI's `/prompt` endpoint
3. **Poll Status**: Monitors job completion via `/history` endpoint
4. **Retrieve Audio**: Returns the path to the generated audio file

## Troubleshooting

### Connection Refused

- Verify ComfyUI is running: `curl http://$COMFYUI_HOST:$COMFYUI_PORT/system_stats`
- Check host and port settings

### Job Timeout

- Large models (3B) take longer to generate
- Try smaller models (0.5B, 1.7B) for faster results

### Output Not Found

- Check ComfyUI's output directory configuration
- Verify file permissions

## API Reference

The skill uses ComfyUI's native API endpoints:

- `POST /prompt` - Submit workflow
- `GET /history` - Check job status
- Output files are saved to ComfyUI's configured output directory
