# ComfyUI Skill - 智能图像生成

自动检测 URL 设置，直接输入提示词即可生成图片。

## 自动检测

用户输入包含 URL 时自动设置连接：
```
设置连接 https://localhost:8188
set url: https://localhost:8188
```

## 直接使用

设置连接后，直接发送提示词：
```
生成一只可爱的猫
a beautiful sunset over mountains
```

## API 端点

### REST API (HTTPS)
| 方法 | 端点 | 说明 |
|------|------|------|
| POST | `{server}/api/prompt` | 提交工作流 |
| GET | `{server}/history/{id}` | 获取结果 |
| GET | `{server}/view?filename=xxx` | 获取图像 |

### WebSocket (WSS)
- URL: `wss://{server}/ws`
- 发送: `{"prompt": {...}, "client_id": "xxx"}`
- 接收: `executing`, `executed`, `status`

## 命令

| 命令 | 说明 |
|------|------|
| `set_url <url>` | 手动设置服务器地址 |
| `status` | 检查服务器状态 |
| `generate <提示词>` | 生成图像 |

## 中文翻译

自动将中文提示词转换为英文：
- "可爱的猫" → "masterpiece, best quality, high resolution, cute cat"
- "美丽的日落" → "masterpiece, best quality, high resolution, beautiful sunset"

## 示例

```bash
# 设置连接 (多种方式)
设置连接 https://localhost:8188
set_url https://localhost:8188

# 直接生成
生成一只可爱的猫
a beautiful sunset over mountains

# 查看状态
status
```
