---
name: colormind
description: Generate color palettes and get color suggestions via the Colormind.io API (list models, generate palettes with optional locked colors).
version: 1.1.1
metadata: {"clawdbot":{"emoji":"🎨","requires":{"bins":["node","python3","convert"],"env":[]}}}
---

# Colormind (Color Palette Generator)

⚠️ **Privacy & Security Notice:**
- This skill sends color data to an external service (colormind.io)
- The API uses **unencrypted HTTP** (HTTPS has a self-signed certificate)
- When using `image_to_palette.sh`, derived color data from your images is sent externally
- **Do not use with sensitive/private images** unless you accept this data sharing
- Consider running in a sandbox when processing untrusted images (ImageMagick safety)

Colormind exposes a simple API:
- `POST http://colormind.io/api/` → generate a palette (optionally with locked colors)
- `GET  http://colormind.io/list/` → list available models

## List models

```bash
node {baseDir}/scripts/list_models.mjs
```

## Generate a random palette

```bash
node {baseDir}/scripts/generate_palette.mjs --model default
node {baseDir}/scripts/generate_palette.mjs --model ui
```

## Generate a palette with locked colors

Provide 5 slots. Use:
- an RGB triple: `"r,g,b"` (locks that slot)
- `N` (free slot)

Examples:

```bash
# lock 2 colors, let colormind fill the rest
node {baseDir}/scripts/generate_palette.mjs --model default \
  --input "44,43,44" "90,83,82" N N N

# lock a brand color, keep a free gradient
node {baseDir}/scripts/generate_palette.mjs --model ui \
  --input "0,122,255" N N N N
```

Output:
- always prints JSON
- if `--pretty` is set, also prints a small Markdown block (hex + RGB)

```bash
node {baseDir}/scripts/generate_palette.mjs --model default --pretty
```

## Sample an image → get a palette

Requires ImageMagick (`convert`). This samples a small palette from an image, picks the most frequent color as the "base", then generates a Colormind palette from it.

```bash
# returns JSON with sampled colors + a generated Colormind palette
bash {baseDir}/scripts/image_to_palette.sh /path/to/image.jpg --model ui
bash {baseDir}/scripts/image_to_palette.sh /path/to/image.jpg --model default
```

Notes:
- Colormind may slightly adjust locked colors.
- Models refresh daily (UTC+8).