# ColorKit Reference Index

Welcome to the comprehensive reference for the ColorKit package. Use the links below to navigate the documentation.

## Essentials
- [ColorKit Overview](ColorKit.md) - General introduction and capabilities.
- [Setup & Installation](Setup.md) - How to add ColorKit to your project.
- [Color Operations](ColorOperations.md) - Conversions, gamut mapping, and basic modifications.

## Core API
- [CKColor](CKColor.md) - The main struct, initializers, and persistence.
- [Color Models](ColorModels.md) - Working with OKLAB, HSL, CMYK, etc.
- [Blending & Compositing](Blending.md) - Photoshop-style blend modes.

## Integration & Accessibility
- [Native Bridges](NativeBridges.md) - Integration with SwiftUI, UIKit, AppKit, and Core Graphics.
- [Accessibility](Accessibility.md) - WCAG and APCA contrast checks.

---
[Official Documentation](https://documentation.kamilszpak.com/documentation/colorkit/) | [Project Website](https://kamilszpak.com/pl/colorkit)
