# Collaborate vs Delegate

## Quick Decision Tree

```
Need something DONE? → Delegate
Need something CHALLENGED? → Collaborate
Need something EXPLORED? → Collaborate
Need something EXECUTED? → Delegate
```

## Detailed Comparison

| Aspect | Delegate | Collaborate |
|--------|----------|-------------|
| Goal | Task completion | Perspective gain |
| Relationship | Hierarchical | Horizontal |
| Instructions | Detailed, specific | Open, questioning |
| Context given | Everything needed | Minimal (avoid bias) |
| Model choice | Cheapest that works | Match complexity |
| Expected output | Deliverable | Insight |
| Success metric | Task done correctly | Understanding shifted |

## Spawn Differences

**Delegate spawn:**
```
Task: Refactor auth module to use JWT
Context: [full codebase context]
Output: Updated files, passing tests
Model: Sonnet (cost-effective for code)
```

**Collaborate spawn:**
```
Question: Looking at this auth flow, what security concerns do you see?
Context: [minimal - just the flow diagram]
Output: Your perspective and concerns
Model: Match the complexity needed
```

## When Collaboration Fails

Signs you should have delegated:
- You already knew the answer
- Collaborator's input didn't change anything
- You spent more time discussing than doing

Signs you should have collaborated:
- Delegated task came back wrong multiple times
- You're stuck in a loop of similar solutions
- Outcome works but feels off

## Hybrid Pattern

Sometimes both: Collaborate first to shape approach, then delegate execution.

```
1. Collaborate: "How should we approach X?"
2. Integrate insights into plan
3. Delegate: "Execute plan with these specifics"
```
