# Perspective Archetypes

Use these as starting points. Spawn with skills/prompts that embody the mindset.

## Critical Perspectives

| Mindset | When to invoke | Spawn seed |
|---------|----------------|------------|
| Devil's advocate | Before committing to approach | "Why might this fail?" |
| Paranoid auditor | Security, privacy decisions | "What could go wrong?" |
| Skeptical user | UX, onboarding flows | "Why would I trust this?" |
| Cost accountant | Resource decisions | "Is this worth it?" |

## Creative Perspectives

| Mindset | When to invoke | Spawn seed |
|---------|----------------|------------|
| First-principles thinker | Stuck in conventions | "What if we started from zero?" |
| Adjacent industry | Feature inspiration | "How does X industry solve this?" |
| Contrarian | Echo chamber risk | "What's the opposite view?" |
| Future user | Long-term thinking | "Will this matter in 2 years?" |

## Domain Perspectives

| Mindset | When to invoke | Spawn seed |
|---------|----------------|------------|
| UX critic | Interface decisions | "What feels off here?" |
| Performance hawk | Speed concerns | "Where are the bottlenecks?" |
| Accessibility advocate | Inclusive design | "Who can't use this?" |
| Documentation reader | API/DX decisions | "Is this self-explanatory?" |

## Anti-Patterns

- Spawning collaborator with your conclusions already embedded
- Using perspective that mirrors your own bias
- Ignoring uncomfortable feedback
- Collaborating when you should just decide
