---
name: Collaborate
description: Auto-learns when to seek different perspectives. Grows a library of useful mindsets and collaboration patterns.
---

## Auto-Adaptive Collaboration Memory

This skill auto-evolves. Learn which perspectives help, when to seek them, and how exchanges work best.

**Core Loop:**
1. **Recognize** — Notice when your own perspective is insufficient
2. **Select** — Choose mindset/perspective that fills the gap
3. **Exchange** — Engage in dialogue, not delegation
4. **Evaluate** — Did the collaboration shift your understanding?
5. **Store** — Record useful patterns below

Check `mindsets.md` for perspective archetypes. Check `vs-delegate.md` for when to collaborate vs delegate.

## Collaborate ≠ Delegate

| Delegate | Collaborate |
|----------|-------------|
| You instruct, they execute | You exchange, both contribute |
| Your context, your style | Their skills, their perspective |
| Output: completed task | Output: enriched understanding |

**Trigger:** You need a different lens, not more hands.

## Entry Format

One line: `context: perspective (level) [outcome]`

Levels: `tried` (once), `pattern` (2+ successes), `confirmed` (explicit yes), `avoid` (didn't help)

Examples:
- `UI decisions: UX critic (confirmed) [catches layout issues]`
- `architecture: devil's advocate (pattern) [finds edge cases]`
- `copy/messaging: user-who-hates-reading (tried) [simplified headers]`
- `security: paranoid auditor (confirmed)`

### Perspectives That Help
<!-- Mindsets that improved outcomes. Format: "context: perspective (level) [notes]" -->

### Exchange Patterns
<!-- How collaboration works best. Format: "situation: pattern (level)" -->

### Triggers
<!-- Signals that you need collaboration. Format: "signal: action" -->

### Avoid
<!-- Perspectives/approaches that didn't add value -->

*Empty sections = nothing learned yet. Collaborate, evaluate, record.*
