# Cold Outreach — Intent-Based Conversion Framework

Generate high-converting cold outreach (email, SMS, LinkedIn DM) using battle-tested frameworks from Hormozi's $100M Leads, Cleverly, Hypergen, and SalesHandy analysis of 100K+ campaigns.

All outputs go to `workspace/artifacts/`.

## Use when
- Writing cold emails/SMS to prospects (B2B or local service businesses)
- Crafting multi-touch follow-up sequences
- Personalizing outreach at scale for a specific ICP
- Evaluating/rewriting existing outreach copy
- Building lead magnets to pair with cold outreach
- Generating Upwork proposals or freelance pitches

## Don't use when
- Warm introductions or inbound leads (they already know you — just be helpful)
- Mass newsletters or marketing blasts (different discipline: content marketing)
- Internal team communication
- Responding to existing conversations or support tickets
- Social media posts or ads (different format, different psychology)

## Negative examples
- "Write me a blog post" → No. This is for 1:1 outreach, not content marketing.
- "Send a thank-you email to a client" → No. That's relationship management, not cold outreach.
- "Create a landing page" → No. Wrong funnel stage entirely.
- "Help me respond to this customer complaint" → No. That's support, not prospecting.

## Edge cases
- Upwork proposals → YES. It's cold outreach to a job poster. Use Template E.
- LinkedIn connection request + message → YES. Use Template F (under 300 chars for request).
- Re-engaging a dead lead (6+ months cold) → YES. Treat as cold — they've forgotten you.
- Warm intro that went cold → Borderline. If >30 days no reply, treat as cold with context.

---

## The Science: Why Most Cold Outreach Fails

Most cold emails go unanswered — Hunter.io reports 95.9%, though real rates vary by industry and targeting quality (80-95% is the realistic range). The failures share common patterns:

### Instant-Delete Triggers (never do these)
1. **Ego-centric opener**: "We're the leading..." / "I'm excited to share..." — Nobody cares about you yet.
2. **Generic spray**: Same message to 1,000 people → 2.1% reply. 50 targeted → 5.8% reply.
3. **Hard sell in email #1**: Pricing, demos, "book a call" before establishing any value → pushy, dead.
4. **"Hope this finds you well"**: Signals mass send. Prospect's brain auto-deletes.
5. **"Just checking in" / "Circling back"**: Zero value added. Each touch must earn attention.
6. **Wall of text**: Cold emails over 125 words lose 50%+ of readers. Ideal: 50-100 words.

### The Psychology That Works
- **3-Second Rule**: Prospects decide in 3 seconds whether to keep reading. First line must prove you researched THEM.
- **Reciprocity**: Give value before asking (Hormozi's lead magnet principle — solve a small problem free, they want your paid solution).
- **Pattern interrupt**: Break the template feel. Specificity is the antidote to spam.
- **Loss aversion**: "You're losing X" hits harder than "You could gain X."

---

## Hormozi's 4-Step Cold Outreach System

From $100M Leads (generates 20,000+ leads/day):

### Step 1: Build the List (ICP-First)
Define your Ideal Customer Profile BEFORE writing a single word:
- **Who**: Industry, company size, role/title, geography
- **What pain**: Specific problem they face (not generic "grow revenue")
- **What signal**: What indicates they need help NOW? (hiring, expanding, bad reviews, no automation)
- **Where to find**: LinkedIn Sales Nav, Google Maps, industry directories, job boards

**Quality check**: If you can't describe their specific daily frustration in one sentence, your ICP isn't sharp enough.

### Step 2: Personalize to Trigger Response
Go beyond `{FirstName}`. Reference:
- Their company's recent news, hire, or milestone
- A specific page on their website (proves you looked)
- A mutual connection or shared experience
- A problem visible from the outside (no online booking, bad Yelp response, etc.)

### Step 3: Lead with Value (The Lead Magnet Principle)
Every cold email should give something:
- An insight they didn't have ("businesses like yours are losing X because of Y")
- A quick win ("here's one thing you can fix today")
- Social proof ("we helped [similar business] achieve [specific result]")

**Hormozi's rule**: If your free stuff isn't good enough to charge for, it's not good enough to give away.

### Step 4: Automate the Sequence
One email doesn't convert. Build a 3-5 touch sequence:
- Most positive replies come after follow-ups (commonly cited as 60%, though real rates vary — the principle holds: persistence pays)
- Each follow-up adds NEW value (never "just bumping this")
- Space touches 3-5 days apart
- Mix channels when possible (email → LinkedIn → email → SMS)

---

## Copywriting Frameworks

Pick the framework that matches your prospect's awareness level:

### PAS — Problem, Agitate, Solve
**Best for**: Prospects who KNOW they have a problem but haven't fixed it.
```
[PROBLEM] Noticed [Business] doesn't have [specific thing].
[AGITATE] Most [business type] in [area] lose [X customers/dollars] monthly because of this — and it compounds.
[SOLVE] We built a [solution] for [similar business] that [specific result in timeframe].

Worth 10 minutes to see how it works?
```

### BAB — Before, After, Bridge
**Best for**: Prospects who don't realize they have a problem.
```
[BEFORE] Right now, [Business] is [current state — manual booking, no reviews, etc.].
[AFTER] Imagine [desired state — automated scheduling, 5-star reviews flowing in, phone never missed].
[BRIDGE] We help [business type] get there with [method]. [Similar business] made the switch in [timeframe].

Quick look?
```

### AIDA — Attention, Interest, Desire, Action
**Best for**: Prospects you need to grab with a hook.
```
[ATTENTION] [Surprising stat or observation about their business]
[INTEREST] We've been studying [their industry] and found that [insight].
[DESIRE] [Similar business] used this to [specific desirable result].
[ACTION] Can I share the playbook? Takes 2 minutes to read.
```

### The Goated One-Liner
**Best for**: Busy executives, second/third follow-ups, SMS.
```
[Observation] + [Result for similar company] + [Soft ask]

Example: "Saw [Business] is still using [old method] — helped [competitor] cut [pain] by [X%]. Worth a look?"
```

---

## Templates

### Template A: Local Service Business (Alfred-style)
```
Subject: Quick question about [Business Name]

Hi [Name],

I looked at [Business Name] online — [specific observation: no online booking, reviews stopped 3 months ago, website doesn't show availability].

I help [business type] in [area] fix exactly this. One client went from [X missed calls/week] to [Y booked appointments/week] in [timeframe] with automated [SMS/booking/reviews].

Would it help to see a 2-minute walkthrough of how it works?

[Signature]
```

### Template B: B2B SaaS / Tech
```
Subject: [Their company] + [your solution category]

Hi [Name],

Noticed [Company] just [trigger: raised funding, hired for X role, launched Y].

When [similar companies] hit that stage, they usually struggle with [specific pain]. We helped [reference client] solve it — [specific metric].

Want me to send over the case study?

[Signature]
```

### Template C: Follow-Up #1 (Value Add, Day 3-4)
```
Subject: Re: [original subject]

Hi [Name],

Quick thought — [industry stat or tactical tip they can use regardless of buying].

This is what [specific client] did before working with us, and it alone moved the needle [X%].

Happy to share more if useful.

[Signature]
```

### Template D: Follow-Up #2 (Breakup, Day 12-14)
```
Subject: Closing the loop

Hi [Name],

I've reached out a couple times about [topic]. Totally fine if the timing's off.

If [pain point] becomes a priority down the road, I'm here. Otherwise I'll get out of your inbox.

[Signature]
```

### Template E: Upwork / Freelance Proposal
```
[Opening]: Reference THEIR specific project details (proves you read it, not mass-applying)
[Credibility]: One relevant result — "[Similar project] → [outcome] in [timeframe]"
[Differentiator]: What you'll do that other applicants won't
[De-risk]: "Happy to do [small first milestone] so you can evaluate before committing"
[CTA]: Specific next step, not vague
```

### Template F: LinkedIn Connection Request (<300 chars)
```
Hi [Name] — saw your [post/company/role]. Working on [relevant thing] and thought we'd have good overlap. Would love to connect.
```

---

## Sequence Blueprint

| Touch | Day | Channel | Framework | Purpose |
|-------|-----|---------|-----------|---------|
| 1 | 0 | Email | PAS or BAB | Problem-aware opener |
| 2 | 3 | LinkedIn | — | Connect + engage their content |
| 3 | 5 | Email | Value-add | Share insight/case study |
| 4 | 10 | SMS/Email | One-liner | Brief personal touch |
| 5 | 14 | Email | Breakup | Close the loop gracefully |

---

## Metrics & Benchmarks

| Metric | Bad | Average | Good | Great |
|--------|-----|---------|------|-------|
| Open rate | <30% | 40-50% | 50-65% | 65%+ |
| Reply rate | <2% | 3-5% | 5-8% | 8%+ |
| Positive reply | <1% | 1-2% | 2-4% | 4%+ |
| Meeting booked | <0.5% | 0.5-1% | 1-2% | 2%+ |

**Diagnostic**:
- Low opens → subject line problem
- Opens but no replies → message relevance or CTA problem
- Replies but no meetings → offer or timing problem
- Meetings but no close → sales conversation problem (outside this skill's scope)

---

## Deliverability Checklist

- [ ] SPF, DKIM, DMARC records configured on sending domain
- [ ] Sending from secondary domain (protect primary brand domain)
- [ ] Domain warmed up 2+ weeks (start with 5/day, increase 5/day)
- [ ] Under 50 emails/day per mailbox
- [ ] No spam trigger words ("free," "guarantee," "act now," "limited time")
- [ ] Plain text or minimal HTML (no heavy images/formatting)
- [ ] Unsubscribe link included (CAN-SPAM / GDPR compliance)
- [ ] Bounce rate under 3% (verify list before sending)
- [ ] Track engagement: opens, replies, unsubscribes — adjust weekly

---

## Key Numbers
- Cold email ROI: $30-50 per $1 spent depending on execution (Litmus: $36, ProfitOutreach: $42, others: $30-50 range)
- 50 targeted emails outperform 1,000 generic by 2.7x on reply rate
- Most conversions require 2+ follow-ups (the exact % varies, but single-touch outreach consistently underperforms)
- Ideal cold email: 50-100 words
- Best send times: Tuesday-Thursday, 8-10 AM recipient's timezone
