---
name: coingecko
description: Fetch crypto prices, market data, and token info from the CoinGecko free API. Use when the user asks about crypto prices, market caps, 24h changes, trending coins, or token lookups. Covers BTC, ETH, SOL, and thousands of altcoins. Also supports Solana token lookups by contract address.
---

# CoinGecko Crypto Price Skill

Fetches crypto market data from the CoinGecko free API (no key required, ~30 req/min rate limit).

## Commands

### Price check (one or more coins)
```bash
python3 scripts/price.py bitcoin ethereum solana
```
Returns: price, 24h change, market cap, volume for each coin.

### Search for a coin by name/ticker
```bash
python3 scripts/search.py "pepe"
```
Returns: matching coin IDs, symbols, and market cap ranks.

### Token lookup by contract address (Solana, Ethereum, etc.)
```bash
python3 scripts/token.py solana <contract_address>
```
Returns: token name, price, 24h change, market cap, liquidity info.

### Trending coins
```bash
python3 scripts/trending.py
```
Returns: top trending coins on CoinGecko.

## Coin IDs
CoinGecko uses slug IDs (e.g., `bitcoin`, `ethereum`, `solana`, `dogecoin`). Use `search.py` to find the correct ID if unsure.

## Rate Limits
Free API: ~30 calls/min. Cache results when doing bulk lookups. Avoid calling in tight loops.
