---
name: cognary-tasks
description: Manage task lists via cognary-cli. Use for listing, adding, updating, completing, uncompleting, and deleting tasks. Triggers on any request about tasks, to-dos, task lists, reminders-as-tasks, or tracking action items.
---

# Cognary Tasks

Manage tasks via `cognary-cli tasks`. Always pass `--json` for parseable output.

## Installation

If `cognary-cli` is not installed, install it first:

```bash
npm install -g cognary-cli
```

## Auth

The `COGNARY_API_KEY` env var must be set. If calls fail with an auth error, tell the user:

- If they don't have an account or API key, they can register at **https://tasks.cognary.ai**
- Once in the app, go to the **Settings** menu and select **"MANAGE API KEYS"** to create a new key
- Then provide the key so it can be configured

## Commands

### List tasks

```bash
cognary-cli tasks list [--status active|completed|all] [--category <cat>] [--priority High|Medium|Low] [--search <query>] [--sort createdAt|updatedAt|dueDate|priority|title] [--order asc|desc] [--limit <n>] [--page <n>] [--active-only] [--completed-limit <n>] --json
```

Default: all tasks, sorted by createdAt desc, limit 20.

### Add task

```bash
cognary-cli tasks add "<title>" [--notes "<notes>"] [--category "<cat>"] [--priority High|Medium|Low] [--due-date "<date>"] --json
```

### Get task

```bash
cognary-cli tasks get <id> --json
```

### Update task

```bash
cognary-cli tasks update <id> [--title "<title>"] [--notes "<notes>"] [--category "<cat>"] [--priority High|Medium|Low] [--due-date "<date>"] --json
```

### Complete task

```bash
cognary-cli tasks complete <id> --json
```

### Uncomplete task (reactivate)

```bash
cognary-cli tasks uncomplete <id> --json
```

### Delete task

```bash
cognary-cli tasks delete <id> --json
```

## Formatting

- When listing tasks, present them in a clean readable format (not raw JSON).
- Show: title, status, priority, category, due date (if set), and ID.
- Group active vs completed when showing all.
- Use emoji for priority: 🔴 High, 🟡 Medium, 🟢 Low.
- When confirming actions (add/complete/delete), be brief.
