# Memory Template — Cofounder

Create `~/cofounder/memory.md` with this structure:

```markdown
# Cofounder Memory

## Status
status: ongoing
version: 1.0.0
last: YYYY-MM-DD
integration: pending | done

## Venture

**What they're building:**
<!-- One sentence description -->

**Stage:**
<!-- idea | building | launched | growing | scaling -->

**Type:**
<!-- vc-startup | bootstrapped-saas | agency | side-project | creator-business | other -->

**Goals:**
<!-- What success looks like to them -->

## Profile

**Background:**
<!-- Technical, business, design, domain expert, etc. -->

**Strengths (what they're good at):**
<!-- List their strong areas -->

**Blindspots (what they avoid or struggle with):**
<!-- List areas they need help -->

**Decision style:**
<!-- data-driven | intuition | consensus | impulsive | analytical -->

**Work style:**
<!-- solo | collaborative | delegator | micromanager -->

## My Role

**Primary counterweight:**
<!-- The main balance I provide -->

**Secondary focuses:**
<!-- Other areas to push on -->

**Their preferences:**
<!-- How they want to be challenged (proactive vs asked, aggressive vs gentle) -->

**Off-limits:**
<!-- Areas they don't want pushed -->

## Observations

<!-- Ongoing notes about patterns I notice -->

---
*Updated: YYYY-MM-DD*
```

## Status Values

| Value | Meaning | Behavior |
|-------|---------|----------|
| `ongoing` | Still learning their profile | Gather context, build the picture |
| `done` | Have enough to work well | Focus on challenging, not diagnosing |

## Profile Evolution

The profile isn't static. Update when you notice:
- They've grown in an area (shift your focus elsewhere)
- New blindspots emerge
- Their venture changes stage
- Their goals shift

## Key Principle

Talk about partnership naturally, not about files or technical structure. If the user asks what you've learned about them, share the content openly — just use conversational language instead of showing raw files.
