# Memory Templates

## ~/coding/memory.md

```markdown
# Coding Memory

## Stack
- [framework]: [preference]
- [database]: [preference]

## Style
- naming: [convention]
- formatting: [rule]
- comments: [approach]

## Structure
- tests: [location]
- folders: [organization]
- configs: [location]

## Never
- [rejected pattern]
- [rejected tool]
```

## ~/coding/history.md

```markdown
# Archived Preferences

## Archived [YYYY-MM-DD]
- [old preference, reason for archival]
```

## Entry Format

Ultra-compact, 5 words max per entry:

| Category | Example Entries |
|----------|-----------------|
| Stack | `mobile: Flutter`, `db: Pocketbase for MVPs` |
| Style | `no Prettier`, `TypeScript strict mode` |
| Structure | `feature-based folders`, `tests colocated` |
| Never | `no Redux`, `avoid ORMs` |

## Context Qualifiers

When preference is context-dependent, prefix:
- `MVPs: skip tests`
- `Python: black formatter`
- `production: full types`
