---
name: coding-as-dressing
description: 用日常穿搭比喻解释代码，帮助小白理解。当用户要求用穿搭、穿衣、衣柜、outfit 比喻解释代码，或提到 Coding as Dressing 时使用。
---

# Coding as Dressing - 穿搭式代码解释

用普通人日常穿衣服的逻辑，帮小白理解代码结构和问题。

## 使用时机

- 用户选中代码并说「用穿搭/穿衣比喻解释」
- 用户说「这段代码什么意思」「帮我用简单的话解释」
- 用户提到 Coding as Dressing

## 解释风格

- **口语化**：像聊天，不说「宛如」「恰似」
- **精简**：一句话说清楚，不堆砌
- **日常**：白T、牛仔裤、帆布鞋，不说礼服蕾丝
- **可操作**：指出能删、能并、要补的地方

---

## 代码 ↔ 穿搭 映射表

### 基础概念

| 代码 | 穿搭比喻 |
|------|----------|
| 变量 | 可换的配饰：帽子、包、鞋，换一个就是新效果 |
| 函数 | 一件完整单品：上衣、裤子、外套，有固定作用 |
| 循环 | 同一件衣服反复穿，做同样的事 |
| 条件 if/else | 看天气选穿啥：下雨穿外套，晴天穿短袖 |
| 项目入口 | 出门前的第一件：先穿上衣还是先穿裤子 |
| 依赖/import | 衣服之间的搭配：这件上衣得配那条裤子 |

### 问题与修改

| 代码问题 | 穿搭比喻 | 建议 |
|----------|----------|------|
| 冗余/重复函数 | 衣柜里两件几乎一样的白T | 留一件就行 |
| 死代码 | 买来没穿过的衣服 | 可以断舍离 |
| 重复逻辑 | 两条差不多款式的牛仔裤 | 合并成一条 |
| 缺失错误处理 | 上衣有了，没配裤子 | 补上 |
| 依赖缺失 | 穿了外套没穿内搭 | 把缺的补上 |

---

## 输出格式

1. **先给一句话总览**：这段代码在干嘛
2. **按结构拆解**：用穿搭比喻说清各部分
3. **有问题就指出**：冗余、缺失、重复，用比喻说明+建议

---

## 示例

**输入代码：**
```python
def get_user(id):
    return users[id]

def fetch_user(id):
    return users[id]
```

**输出（穿搭式）：**

这段代码在干一件事：根据 id 找人。但你有**两件一样的白T**——`get_user` 和 `fetch_user` 做的完全相同，相当于衣柜里两条一模一样的牛仔裤。留一个就行，删掉 `fetch_user`，以后统一用 `get_user`。

---

**输入代码：**
```javascript
for (let i = 0; i < 5; i++) {
  console.log("Hello");
}
```

**输出（穿搭式）：**

这是一个**同一件衣服穿五次**——循环把同一件事重复做 5 遍，每次都输出 "Hello"。就像你这周连续五天穿同一件卫衣上班，每次出门都是同一套动作。

---

**输入代码：**
```python
if weather == "rain":
    wear("coat")
else:
    wear("tshirt")
```

**输出（穿搭式）：**

这是**看天气选穿啥**——下雨穿外套，不下雨穿短袖。if/else 就是根据条件选不同的「单品」，二选一，每次只穿一套。
