---
name: codex-cleaner
description: >
  Monitor and clean invalid codex auth files from CPA (Codex Provider Agent).
  Checks quota status, disables 401 files, double-verifies before deletion.
  Use when user mentions "codex clean", "clean auth", "auth files", "CPA清理",
  "codex 认证", "清理无效文件", or needs to manage codex authentication files.
---

# Codex Auth File Cleaner

Clean invalid codex auth files via CPA management API. Zero dependencies (pure Python stdlib).

## First Run

Run setup wizard to configure CPA URL and admin key:

```bash
python3 scripts/codex_cleaner.py setup
```

Config saved to `config.json` (auto-created, gitignored). Config priority: CLI args > env vars (`CPA_URL`/`CPA_KEY`) > config.json.

## Commands

```bash
# View status
python3 scripts/codex_cleaner.py status
python3 scripts/codex_cleaner.py status --json

# Check active files, disable 401s
python3 scripts/codex_cleaner.py check

# Double-verify disabled files, then delete confirmed 401s
python3 scripts/codex_cleaner.py delete

# Full clean (check + delete), output human-readable report
python3 scripts/codex_cleaner.py clean --report

# Full clean, output JSON
python3 scripts/codex_cleaner.py clean --json

# Loop mode (default 300s interval)
python3 scripts/codex_cleaner.py monitor -i 300
```

## Workflow

```
clean = check + delete

check:  fetch active codex files → concurrent quota check → disable 401s
delete: fetch disabled files → verify#1 (401?) → wait 2s → verify#2 (still 401?) → delete
```

Double verification prevents accidental deletion of temporarily failing files.

## Nanobot Integration

For periodic monitoring, run `clean --report` via HEARTBEAT or cron, then send the stdout report to the user via `message` tool.

Example:
```bash
cd ~/.nanobot/workspace/skills/codex-cleaner && python3 scripts/codex_cleaner.py clean --report
```

## Report Format

```
🧹 Codex 认证清理报告
⏰ 2026-02-26 13:50:00

📊 清理前
  总计: 100 | 可用: 85 | 已禁用: 15

🔍 检查阶段
  检测: 85 | 失效(401): 3 | 已禁用: 3

🗑️ 删除阶段
  待删: 18 | 验证通过: 15 | 已删除: 15 | 跳过: 3

📊 清理后
  总计: 85 | ✅可用: 82 | ⛔已禁用: 3

⚡ 本次清理: 禁用 3 + 删除 15 = 18 个无效文件
```

## Config File

`config.json` (auto-generated by setup wizard):

```json
{
  "cpa_url": "http://YOUR_CPA_HOST:PORT",
  "cpa_key": "YOUR_ADMIN_KEY",
  "concurrency": 20,
  "monitor_interval": 300,
  "notify": {
    "enabled": true,
    "channel": "telegram",
    "chat_id": "YOUR_CHAT_ID"
  }
}
```
