---
name: 需求调研与发现
description: 帮助识别、评估和验证需求，在开始设计之前确保方向正确
version: 1.5.0
updated: 2026-01-19
---

# 需求调研与发现 Skill

> 做正确的事，比正确地做事更重要。本 Skill 帮助你在开始设计之前，确保需求方向正确。

## 速查表

| 我想... | 跳转到 |
|---------|--------|
| 评估需求优先级 | [RICE 评分](#rice-需求评分) |
| 评估 AI 可行性 | [AI 能力边界评估](#ai-能力边界评估) |
| 做用户调研 | [快速用户调研](#快速用户调研) |
| 验证需求假设 | [假设验证循环](#假设验证循环) |
| 生成调研报告 | [调研报告模板](#调研报告输出) |

**核心流程**: 识别需求来源 -> 用户调研 -> 评估优先级 -> AI可行性 -> 输出调研报告

---

## 关联 Skill

| Skill | 关系 | 说明 |
|-------|------|------|
| doc-writing | 下一步 | 调研完成后，撰写需求文档 |
| doc-review | 后续 | 需求文档完成后评审 |
| development | 后续 | 评审通过后开发 |
| code-review | 后续 | 开发完成后代码评审 |

**完整工作流**: `requirement-discovery` -> `doc-writing` -> `doc-review` -> `development` -> `code-review`

---

## 使用场景

- "帮我调研一下这个需求"
- "评估一下这个功能要不要做"
- "这个 AI 功能技术上可行吗"
- "帮我做一下用户调研"
- "这几个需求哪个优先级更高"

---

## 调研流程

### 第一步: 识别需求来源

需求通常来自以下 4 个来源:

| 来源 | 说明 | 如何获取 |
|------|------|---------|
| **用户反馈** | 用户直接提出的需求 | 客服记录、用户访谈、评论 |
| **竞品功能** | 竞争对手有我们没有 | 竞品分析 (见 doc-writing) |
| **团队洞察** | 团队发现的机会点 | 头脑风暴、日常观察 |
| **市场趋势** | 行业发展方向 | 行业报告、技术趋势 |

**需求来源记录模板**:
```markdown
## 需求来源记录

| 来源类型 | 需求描述 | 提出人/渠道 | 日期 |
|---------|---------|------------|------|
| 用户反馈 | [需求描述] | [来源] | YYYY-MM-DD |
```

---

### 第二步: 快速用户调研

> 不需要重型的调研，5 分钟用户访谈法足够

#### 5 分钟用户访谈法

**核心问题 (按顺序问)**:

| # | 问题 | 目的 |
|---|------|------|
| 1 | "你现在是怎么解决这个问题的?" | 了解现状 |
| 2 | "这个过程中最让你头疼的是什么?" | 挖掘痛点 |
| 3 | "如果有个工具能帮你 [解决痛点]，你愿意用吗?" | 验证需求 |
| 4 | "你愿意为此付费吗? 大概多少?" | 验证价值 |
| 5 | "还有什么我没问到但你想说的?" | 开放收集 |

**访谈记录模板**:
```markdown
## 用户访谈记录

**访谈对象**: [用户基本信息]
**访谈日期**: YYYY-MM-DD
**访谈时长**: X 分钟

### 现状
[用户目前如何解决问题]

### 痛点
[用户最大的痛点是什么]

### 需求验证
- 需求是否存在: [OK]/[X]
- 愿意使用: [OK]/[X]
- 愿意付费: [OK]/[X] [金额]

### 其他发现
[用户提到的其他有价值信息]
```

#### 用户画像模板

```markdown
## 目标用户画像

### 基本信息
| 项目 | 描述 |
|------|------|
| 用户类型 | [如: 产品经理/开发者/普通用户] |
| 年龄段 | [如: 25-35] |
| 技术水平 | [高/中/低] |

### 核心特征
- **目标**: [用户想要达成什么]
- **痛点**: [用户最大的困扰]
- **现有解决方案**: [目前怎么解决]
- **为什么不满意**: [现有方案的问题]

### 使用场景
[用户在什么情况下会使用我们的产品]
```

---

### 第三步: RICE 需求评分

> 量化评估需求优先级，避免主观判断

#### RICE 评分公式

```
RICE 分数 = (Reach x Impact x Confidence) / Effort
```

| 因素 | 含义 | 评分方式 |
|------|------|---------|
| **R**each (触达) | 影响多少用户? | 预计用户数 / 时间周期 |
| **I**mpact (影响) | 对用户的影响程度? | 3=大 / 2=中 / 1=小 / 0.5=极小 |
| **C**onfidence (信心) | 对估算的信心? | 100%=高 / 80%=中 / 50%=低 |
| **E**ffort (投入) | 需要多少人力? | 人天数 |

#### RICE 评分表模板

```markdown
## 需求 RICE 评分

| 需求 | R(触达) | I(影响) | C(信心) | E(投入) | RICE分数 | 优先级 |
|------|---------|---------|---------|---------|----------|--------|
| 需求A | 1000 | 3 | 80% | 5 | 480 | P0 |
| 需求B | 500 | 2 | 50% | 10 | 50 | P2 |
| 需求C | 2000 | 1 | 100% | 2 | 1000 | P0 |

### 优先级结论
1. **P0 (必做)**: 需求C (RICE=1000)、需求A (RICE=480)
2. **P1 (应做)**: ...
3. **P2 (可选)**: 需求B (RICE=50)
```

#### RICE 评分指南

**Reach (触达) 估算**:
- 日活用户 x 使用比例
- 例: 1000 DAU x 50% = 500

**Impact (影响) 评分**:
| 分数 | 含义 | 示例 |
|------|------|------|
| 3 | 巨大影响 | 核心功能，显著提升体验 |
| 2 | 较大影响 | 重要功能，明显改善 |
| 1 | 一般影响 | 有帮助，锦上添花 |
| 0.5 | 微小影响 | 可有可无 |

**Confidence (信心) 评分**:
| 分数 | 含义 |
|------|------|
| 100% | 有数据支撑，非常确定 |
| 80% | 有用户反馈，比较确定 |
| 50% | 直觉判断，不太确定 |

**Effort (投入) 估算**:
- 单位: 人天
- 包含: 设计 + 开发 + 测试

---

### 第四步: AI 能力边界评估

> AI 不是万能的，提前评估技术可行性

#### AI 可行性检查清单

| 检查项 | 问题 | 评估 |
|--------|------|------|
| **效果预期** | AI 能达到用户期望的效果吗? | [OK] 能 / [!] 部分能 / [X] 不能 |
| **数据依赖** | 需要什么数据? 我们有吗? | [OK] 有 / [!] 需获取 / [X] 无法获取 |
| **模型能力** | 现有模型能支持吗? | [OK] 能 / [!] 需调优 / [X] 不能 |
| **响应时间** | 能在用户可接受的时间内响应吗? | [OK] 能 / [!] 边界 / [X] 太慢 |
| **成本可控** | Token 成本在预算内吗? | [OK] 可控 / [!] 边界 / [X] 太贵 |
| **内容安全** | 有内容安全风险吗? | [OK] 安全 / [!] 需审核 / [X] 高风险 |

#### AI 功能可行性评估模板

```markdown
## AI 功能可行性评估

### 功能描述
[描述 AI 功能的目标]

### 评估结果

| 维度 | 评估 | 说明 |
|------|------|------|
| 效果预期 | [OK]/[!]/[X] | [说明] |
| 数据依赖 | [OK]/[!]/[X] | [说明] |
| 模型能力 | [OK]/[!]/[X] | [说明] |
| 响应时间 | [OK]/[!]/[X] | [说明] |
| 成本可控 | [OK]/[!]/[X] | [说明] |
| 内容安全 | [OK]/[!]/[X] | [说明] |

### 可行性结论
- [OK] **可行**: 可以开始设计
- [!] **有条件可行**: 需要 [条件]
- [X] **不可行**: 原因 [原因]

### 建议方案
[如果有条件可行或不可行，替代方案是什么]
```

#### 常见 AI 能力边界

| 场景 | AI 能力 | 注意事项 |
|------|--------|---------|
| 对话/问答 | [OK] 擅长 | 可能产生幻觉 |
| 文本生成 | [OK] 擅长 | 需要审核 |
| 翻译 | [OK] 擅长 | 专业领域需调优 |
| 代码生成 | [!] 中等 | 需要人工审核 |
| 图像识别 | [!] 中等 | 准确率有限 |
| 实时数据 | [X] 不擅长 | 需要外部数据源 |
| 100%准确 | [X] 无法保证 | 必须接受误差 |

---

### 第五步: 假设验证循环

> 创业的本质是验证假设

#### 假设验证循环

```
构建假设 -> 设计 MVP -> 收集数据 -> 验证/推翻 -> 迭代
```

#### 需求假设模板

```markdown
## 需求假设

### 假设陈述
我们相信 [目标用户] 在 [场景] 下，
有 [痛点/需求]，
如果我们提供 [解决方案]，
他们会 [期望行为]。

### 验证指标
- 成功指标: [如何判断假设成立]
- 失败指标: [如何判断假设不成立]

### 验证方式
- [ ] 用户访谈 (N=?)
- [ ] 问卷调查 (N=?)
- [ ] MVP 测试
- [ ] A/B 测试

### 验证结果
- 状态: [OK] 验证通过 / [X] 推翻 / [~] 需要更多数据
- 结论: [基于数据的结论]
- 下一步: [行动计划]
```

#### MVP 思维

| 原则 | 说明 |
|------|------|
| **最小** | 只实现验证假设所需的最小功能 |
| **可行** | 必须是可用的，不是 Demo |
| **产品** | 为真实用户解决真实问题 |

---

## 调研报告输出

完成调研后，输出以下格式的报告:

```markdown
# [需求名称] 调研报告

## 报告信息
| 项目 | 内容 |
|------|------|
| 需求来源 | [用户反馈/竞品/团队洞察/市场趋势] |
| 调研日期 | YYYY-MM-DD |
| 调研结论 | [OK] 建议推进 / [!] 需要更多验证 / [X] 不建议推进 |

## 需求概述
[一句话描述需求]

## 目标用户
[用户画像简述]

## RICE 评分
| R(触达) | I(影响) | C(信心) | E(投入) | RICE分数 |
|---------|---------|---------|---------|----------|
| X | X | X% | X人天 | X |

## AI 可行性 (如适用)
| 维度 | 评估 |
|------|------|
| 效果预期 | [OK]/[!]/[X] |
| 技术可行 | [OK]/[!]/[X] |
| 成本可控 | [OK]/[!]/[X] |

## 验证情况
- 用户访谈: [X] 人，[结论]
- 竞品对比: [结论]
- 技术评估: [结论]

## 结论与建议
### 结论
[是否建议推进，理由]

### 建议的下一步
1. [行动项1]
2. [行动项2]

### 风险提示
- [风险1]
- [风险2]
```

---

## 调研原则

### 1. 速度优先
- 不要追求完美调研
- 快速验证，快速迭代
- 80% 的信心足够开始

### 2. 数据说话
- 用数据支撑决策
- 避免"我觉得"
- 小样本也比没有强

### 3. 用户视角
- 从用户痛点出发
- 不是"我们能做什么"
- 而是"用户需要什么"

### 4. 接受失败
- 推翻假设也是成功
- 早发现比晚发现好
- 不要为沉没成本坚持

---

## 下一步

调研完成后，使用 **doc-writing** skill 撰写需求文档:
> "帮我写一个需求文档"
