---
name: 需求文档评审
description: 系统性评审需求文档的完整性、一致性、可行性，在开发前发现问题
version: 1.5.0
updated: 2026-01-19
---

# 需求文档评审 Skill

> 在写代码前发现问题，成本最低。本 Skill 帮助你系统性地评审需求文档。

## 速查表

| 评审维度 | 核心问题 |
|---------|---------|
| 完整性 [!] | 功能全? 边界清? 验收明? |
| 一致性 [!] | 术语统一? 前后不矛盾? |
| 可行性 [!] | 能做? 够时间? 依赖稳? |
| 安全性 [!] | 鉴权? 越权? 数据保护? |
| AI专项 [!] | 模型? Prompt? 成本? 降级? |

**快速评审**: 只查 [!] 标记的 5 个核心维度
**评审结论**: [OK]通过 / [!]有条件通过 / [X]不通过

---

## 关联 Skill

| Skill | 关系 | 说明 |
|-------|------|------|
| requirement-discovery | 前置 | 需求调研完成后撰写文档再评审 |
| doc-writing | 上一步 | 使用 doc-writing 撰写的文档需要评审 |
| development | 下一步 | 评审通过后进入开发阶段 |
| code-review | 后续 | 开发完成后进行代码评审 |

**工作流**: `requirement-discovery` -> `doc-writing` -> `doc-review` -> `development` -> `code-review`

---

## 使用场景

- "帮我评审一下这个需求文档"
- "检查一下这个 PRD 有没有问题"
- "这个技术方案靠谱吗"
- "看看这个 AI 功能设计有没有问题"

---

## 复杂评审的会话记录（可选）

当评审范围较大或涉及多处上下文时，可启用会话记录，避免遗漏与重复。
参考模板: `AIWorkFlowSkill/development/references/session-management.md`

---

## 评审模式

| 模式 | 适用场景 | 评审维度 | 时间 |
|------|---------|---------|------|
| **完整评审** | 核心功能 | 全部 10 个 | 30-60分钟 |
| **快速评审** [!] | 紧急修复 | 5 个核心 | 10-15分钟 |

---

## 评审维度

### 核心维度 (快速评审必查) [!]

#### 1. 完整性 [!]
- 背景目标是否清楚?
- 功能清单是否完整?
- 边界条件是否考虑?
- 验收标准是否明确?

#### 2. 一致性 [!]
- 术语是否统一?
- 前后是否矛盾?
- 与现有系统是否冲突?

#### 3. 可行性 [!]
- 技术上能否实现?
- 时间人力是否足够?
- 依赖是否稳定?

#### 4. 安全性 [!]
- 接口是否鉴权?
- 是否有越权风险?
- 敏感数据是否保护?

#### 5. AI 专项 [!] (AI功能必查)
- 模型选型是否合理?
- Prompt 设计是否清晰?
- 成本是否可控?
- 降级方案是否有?
- Prompt 注入是否防护?

### 扩展维度 (完整评审)

#### 6. 性能
- 响应时间要求? 并发能力? 数据量增长?

#### 7. 可测试性
- 验收标准可量化? 测试用例好写?

#### 8. 可维护性
- 是否易扩展? 是否有监控?

#### 9. 依赖风险
- 依赖是否稳定? 降级方案?

#### 10. 创业适配
- MVP 是否精简? 技术债是否记录?

---

## 评审输出格式

```markdown
# 文档评审报告

## 评审信息
| 项目 | 内容 |
|------|------|
| 文档 | [名称] |
| 模式 | 完整/快速 |
| 结论 | [OK]通过 / [!]有条件通过 / [X]不通过 |

## 维度汇总
| 维度 | 状态 | 问题数 |
|------|------|--------|
| 完整性 [!] | [OK]/[!]/[X] | N |
| 一致性 [!] | [OK]/[!]/[X] | N |
| 可行性 [!] | [OK]/[!]/[X] | N |
| 安全性 [!] | [OK]/[!]/[X] | N |
| AI专项 [!] | [OK]/[!]/[X]/N/A | N |

## [BLOCK] 必须修改
1. **[问题]** - 位置: [X] - 建议: [Y]

## [WARN] 建议优化
1. **[问题]** - 建议: [Y]

## 技术债记录
| 技术债 | 偿还计划 |
|--------|---------|
| [债务] | [计划] |

## [GOOD] 亮点
- [亮点]

## 后续行动
- [ ] [待办]
```

---

## 问题级别

| 级别 | 说明 | 处理 |
|------|------|------|
| [BLOCK] Blocker | 必须修改 | 重新评审 |
| [MAJOR] Major | 强烈建议 | 灵活处理 |
| [MINOR] Minor | 建议优化 | 后续优化 |
| [DEBT] Tech Debt | 技术债 | 记录+计划 |

---

## 评审原则

1. **建设性**: 指出问题+给出建议
2. **客观性**: 基于事实，引用位置
3. **优先级**: 先 Blocker，不吹毛求疵
4. **创业务实**: 允许合理技术债，但必须记录

---

## 快速评审

时间紧迫时只查 5 个核心维度: 完整性、一致性、可行性、安全性、AI专项

```markdown
# 快速评审结果
[OK]/[!]/[X] [结论]

## 关键问题
1. [问题]

## 技术债
- [债务]

## 下一步
- [行动]
```

---

## 文档修改规范

### 重要原则

| 原则 | 说明 |
|------|------|
| **评审输出报告** | 评审只输出问题和建议，**不要输出新版本文档** |
| **增量修改** | 使用编辑工具修改原文档，不要重写整个文件 |
| **更新版本** | 修改后更新文档头部的版本号和日期 |

### 评审后的修改流程

```
1. 评审 -> 输出评审报告
2. 作者根据报告 -> 增量修改原文档
3. 修改完成 -> 更新版本号
4. 如需要 -> 再次评审
```

### 修改标记 (可选)

| 标记 | 用途 | 示例 |
|------|------|------|
| ~~删除线~~ | 删除的内容 | ~~旧文案~~ |
| **加粗** | 新增的内容 | **新增功能** |
| `[v1.1]` | 修改批注 | `[v1.1 根据评审修改]` |

---

## 下一步

评审通过后使用 **development** skill:
> "帮我实现这个功能"
