---
version: 4.1.0
name: codecast
description: Stream coding agent sessions (Claude Code, Codex, Gemini CLI, etc.) to a Discord channel in real-time via webhook. Use when invoking coding agents and wanting transparent, observable dev sessions — no black box. Parses Claude Code's stream-json output into clean formatted Discord messages showing tool calls, file writes, bash commands, and results with zero AI token burn. Use when asked to "stream to Discord", "relay agent output", or "make dev sessions visible".
metadata: {"openclaw":{"emoji":"🎬","requires":{"anyBins":["unbuffer","python3"]}}}
---

# Codecast

Live-stream coding agent sessions to Discord. Zero AI tokens burned.

## Setup

First-time setup: see [references/setup.md](references/setup.md) for webhook creation, unbuffer install, bot token, and smoke test.

## Invocation

Launch with `exec background:true`. Background exec sessions survive agent turns and OpenClaw fires `notifyOnExit` automatically when the process ends.

```bash
exec background:true command:"{baseDir}/scripts/dev-relay.sh -w ~/projects/myapp -- claude -p --dangerously-skip-permissions --output-format stream-json --verbose 'Your task here'"
```

Note the session ID from the response — use it to monitor via `process`.

### Options

| Flag | Description | Default |
|------|------------|---------|
| `-w <dir>` | Working directory | Current dir |
| `-t <sec>` | Timeout | 1800 |
| `-h <sec>` | Hang threshold | 120 |
| `-n <name>` | Agent display name | Auto-detected |
| `-r <n>` | Rate limit (posts/60s) | 25 |
| `--thread` | Post into a Discord thread | Off |
| `--skip-reads` | Hide Read tool events | Off |
| `--review <url>` | PR review mode | — |
| `--parallel <file>` | Parallel tasks mode | — |
| `--resume <dir>` | Replay session | — |

For PR review, parallel tasks, Discord bridge, and Codex structured output: see [references/advanced-modes.md](references/advanced-modes.md).

## Agent Launch Checklist

1. **Start background session** → note session ID and PID from response
2. **Post to dev channel** → announce agent name, workdir, task
3. **Write breadcrumb** for completion routing:
   ```bash
   echo '{"channel":"<invoking-channel-id>","relayDir":"<relay-dir>","pid":<PID>}' > /tmp/codecast-pending-<PID>.json
   ```
4. **Log to daily memory** → session ID, relay dir, invoking channel

The breadcrumb file tells the heartbeat precheck where to post results when the session completes. It auto-detects completion by checking if the PID is still alive.

That's it. When the process ends, OpenClaw's `notifyOnExit` fires a system event + heartbeat request. The heartbeat handler reads the result from the relay dir's `stream.jsonl` and posts to the invoking channel.

## Completion Detection

OpenClaw handles this natively:
- `tools.exec.notifyOnExit: true` (default) — system event + heartbeat on process exit
- Heartbeat precheck script detects completed sessions via `/tmp/dev-relay-sessions/`
- No cron watcher needed

**Backup:** Append this to the inner agent's prompt for an additional signal:
```
When completely finished, run: openclaw system event --text "Done: <brief summary>" --mode now
```

## Monitoring

```
process poll sessionId:<id>        # Check status
process log sessionId:<id>         # View recent output
process kill sessionId:<id>        # Stop session
```

## Agent Support

| Agent | Output Mode | Status |
|-------|------------|--------|
| Claude Code | stream-json | Full support |
| Codex | --json JSONL | Full support |
| Any CLI | Raw ANSI | Basic support |

## Session Tracking

- **Active sessions:** `/tmp/dev-relay-sessions/<PID>.json` (auto-removed on end)
- **Event logs:** `/tmp/dev-relay.XXXXXX/stream.jsonl` (7-day auto-cleanup)
- **Interactive input:** `process submit sessionId:<id> data:"message"`

## Reference Docs

- [Setup guide](references/setup.md) — first-time install, webhook, bot token
- [Advanced modes](references/advanced-modes.md) — PR review, parallel tasks, Discord bridge, Codex
- [Discord output](references/discord-output.md) — message formats, architecture, env vars, troubleshooting
