---
name: codebuddy-cli
description: |
  CodeBuddy Code CLI installation, configuration and usage guide. CodeBuddy Code is Tencent's AI-powered CLI programming assistant supporting natural language driven development.
  - MANDATORY TRIGGERS: CodeBuddy, codebuddy, AI CLI, Tencent AI coding, @tencent-ai/codebuddy-code, terminal AI assistant
  - Use when: installing CodeBuddy CLI, configuring CodeBuddy, using CodeBuddy commands, troubleshooting CodeBuddy issues
---

# CodeBuddy CLI Skill

AI-powered terminal programming assistant from Tencent.

## Installation

```bash
# Check prerequisites
node -v  # Requires Node.js 18+
npm -v

# Install globally
npm install -g @tencent-ai/codebuddy-code

# Verify
codebuddy --version
```

## Quick Start

1. Navigate to project directory
2. Run `codebuddy` to start interactive session
3. Choose login method:
   - **Google/GitHub**: International version (Gemini, GPT models)
   - **WeChat (微信)**: China version (DeepSeek models)

## CLI Arguments

| Argument | Description |
|----------|-------------|
| `codebuddy "<prompt>"` | Execute single task |
| `-y` / `--dangerously-skip-permissions` | Skip permission confirmations (sandbox only) |
| `-p` / `--print` | Single execution mode (requires `-y` for file ops) |
| `--permission-mode <mode>` | `acceptEdits`, `bypassPermissions`, `default`, `plan` |
| `--version` | Show version |

### Examples

```bash
# Interactive mode
codebuddy

# Single task
codebuddy "帮我优化这个函数的性能"
codebuddy "生成这个 API 的单元测试"
codebuddy "检查这次提交的代码质量"

# Skip permissions (sandbox only)
codebuddy -p "Review code quality" -y
```

## Slash Commands

| Command | Description |
|---------|-------------|
| `/help` | Display available commands |
| `/status` | Show account info and current model |
| `/login` | Switch accounts |
| `/logout` | Sign out |
| `/clear` | Reset conversation history |
| `/exit` | End session |
| `/config` | Open configuration |
| `/doctor` | Diagnose issues |
| `/cost` | Token usage statistics |
| `/init` | Generate CODEBUDDY.md project guide |
| `/memory` | Edit project memory files |

Type `?` during session for keyboard shortcuts.

## Custom Commands

Create `.md` files in:
- **Project**: `.codebuddy/commands/`
- **Global**: `~/.codebuddy/commands/`

## Update

```bash
npm install -g @tencent-ai/codebuddy-code
```

## Security Notes

`--dangerously-skip-permissions` risks: file deletion, scope creep, data loss. **Never use in production.**
