---
name: code-quality-analyzer
version: "1.0.0"
description: "代码质量分析器 | Professional code quality analyzer. 静态代码分析、代码异味检测、复杂度评估、最佳实践建议。适用于 JavaScript、TypeScript、Python、Java 等主流语言。"
metadata:
  openclaw:
    emoji: 🔍
    pricing:
      single_file: "5 USDC"
      project_analysis: "20 USDC"
      team_subscription: "50 USDC/month"
---

# Code Quality Analyzer 🔍

专业的代码质量分析服务，帮助开发者写出更好的代码。

## 服务内容

### 1. 单文件分析 ($5)
- 代码复杂度评估
- 潜在bug检测
- 命名规范检查
- 改进建议

### 2. 项目级分析 ($20)
- 整体架构评估
- 模块依赖分析
- 代码重复检测
- 性能优化建议
- 安全漏洞扫描

### 3. 团队订阅 ($50/月)
- 无限次分析
- 自定义规则
- CI/CD 集成指南
- 优先支持

## 支持的语言

- JavaScript / TypeScript
- Python
- Java
- Go
- Rust
- C/C++

## 分析维度

### 1. 可读性
- 命名规范
- 注释质量
- 代码格式

### 2. 可维护性
- 函数复杂度
- 模块耦合度
- 代码重复

### 3. 性能
- 算法效率
- 内存使用
- 潜在瓶颈

### 4. 安全性
- 常见漏洞
- 敏感数据处理
- 输入验证

## 使用方式

### 方式1：直接对话
将代码贴给我，我会分析并给出建议。

### 方式2：文件分析
```
请分析 /path/to/file.js 的代码质量
```

### 方式3：项目分析
```
请分析 /path/to/project 的整体代码质量
```

## 输出示例

```markdown
# 代码质量报告

## 概览
- 总体评分：B+ (85/100)
- 文件数：12
- 代码行数：2,340
- 问题数：8

## 关键问题

### 🔴 高优先级
1. **src/auth.js:45** - 硬编码的API密钥
   - 建议：使用环境变量存储敏感信息

### 🟡 中优先级
2. **src/utils.js:120** - 函数复杂度过高 (圈复杂度: 15)
   - 建议：拆分为多个小函数

### 🟢 低优先级
3. **src/config.js** - 缺少类型定义
   - 建议：添加TypeScript类型或JSDoc

## 改进建议

1. 添加单元测试（当前覆盖率：0%）
2. 统一代码风格（建议使用Prettier）
3. 添加错误处理中间件

## 优点
✅ 良好的模块化结构
✅ 清晰的函数命名
✅ 合理的目录组织
```

## 定价

| 服务 | 价格 | 交付时间 |
|------|------|----------|
| 单文件分析 | $5 | 即时 |
| 项目分析 | $20 | 24小时 |
| 团队订阅 | $50/月 | - |

---

*好代码 = 好产品 = 好生意 🔍*
