---
name: code-detective
description: Найди баг в коде! Интерактивная игра для тренировки отладки с 3 уровнями сложности. Используй когда пользователь просит "найди баг", "потренироваться в отладке" или хочет проверить внимательность к коду.
user-invocable: true
---

# Code Detective — Найди Баг в Коде

Игра для тренировки навыков отладки. Пользователь ищет ошибки в коде.

## Как использовать

### 1. Запуск игры

Когда пользователь просит "найди баг" или "поиграем в отладку":

```
🔍 Code Detective — Найди баг!

Я покажу код с ошибкой, а ты найдёшь её!

Выбери сложность:
[🟢 Легко] [🟡 Средне] [🔴 Сложно]
```

### 2. Формат вопроса

Покажи код и используй `message` с параметром `buttons`:

```json
{
  "action": "send",
  "channel": "telegram",
  "target": "<user_id>",
  "message": "🐛 Найди баг в этом коде (вопрос 1/5):\n\n```python\ndef greet(name):\n    print(\"Привет, \" + name)\n\ngreet(\"Артём)\n```\n\nЧто не так?",
  "buttons": [
    [{"text": "💡 Подсказка", "callback_data": "hint:q1"}],
    [{"text": "🔄 Пропустить", "callback_data": "skip:q1"}]
  ]
}
```

### 3. Уровни сложности

**🟢 Легко:** Синтаксические ошибки, очевидные опечатки
```python
# Пример: Забыта закрывающая кавычка
name = "Артём
print(name)
```

**🟡 Средне:** Логические ошибки, типичные паттерны
```javascript
// Пример: var вместо let в цикле
for (var i = 0; i < 3; i++) {
  setTimeout(() => console.log(i), 100);
}
// Выведет 3, 3, 3 вместо 0, 1, 2
```

**🔴 Сложно:** Сложные баги, несколько ошибок
```python
# Пример: UnboundLocalError
def counter():
    count = 0
    def increment():
        count += 1  # Ошибка!
        return count
    return increment()
```

### 4. Типичные баги для игры

**Python:**
- Забытые кавычки в строке
- Отступы (indentation)
- Переменная до объявления
- != вместо ==
- Забытый return
- Изменение global без global

**JavaScript:**
- === vs ==
- Забытый await
- this в стрелочных функциях
- var вместо let/const в циклах

**Общие:**
- Бесконечные циклы
- Off-by-one ошибки
- Забытые break в switch

### 5. Подсказки

Если пользователь просит подсказку — дай направление, но не ответ:

```
💡 Подсказка: посмотри на строки с текстом...
```

### 6. Правильный ответ

Когда пользователь угадал:

```
✅ Верно! Забыта закрывающая кавычка!
🎯 +15 очков

💡 Совет: В IDE подсветка помогает найти такие ошибки.

[➡️ Следующий вопрос]
```

### 7. Неправильный ответ

```
❌ Не совсем!

Проблема в строке 4: greet("Артём)
Не хватает закрывающей кавычки.

[➡️ Следующий вопрос]
```

### 8. Финал игры

```
🔍 Code Detective завершён!
━━━━━━━━━━━━━━━━━━
🎯 Найдено багов: 4/5
⭐ Опыт: +400 XP
📈 Ты становишься лучшим детективом!

[🔄 Играть снова]
```

## Стиль общения

- Поощряй: "Хороший глаз!", "Ты на верном пути!"
- Объясняй ошибку просто
- Давай советы как избегать таких багов
- Используй эмодзи: 🐛 🔍 💡 ✅ ❌

## Пример полного цикла

```
User: найди баг!

Bot: 🔍 Code Detective!
Выбери сложность:

[🟢 Легко] [🟡 Средне] [🔴 Сложно]

---

User: [🟢 Легко]

Bot: 🐛 Найди баг (вопрос 1/3):

```python
x = 10
y = 0
result = x / y
print(result)
```

[💡 Подсказка]

---

User: деление на ноль!

Bot: ✅ Верно! ZeroDivisionError!
🎯 +15 очков

[➡️ Следующий вопрос]
```
