---
name: code-cache
description: Semantic code caching for AI agents. Cache, retrieve, and reuse code from prior agent executions.
metadata: {"openclaw":{"emoji":"🏄","homepage":"https://raysurfer.com","requires":{"env":["RAYSURFER_API_KEY"]},"primaryEnv":"RAYSURFER_API_KEY"}}
---

# Code Cache - Semantic Code Caching for AI Agents

This skill enables semantic code caching via the [Raysurfer](https://raysurfer.com) API.

## What It Does

When your agent generates and executes code, Code Cache stores it. When a similar task comes up later, the agent can retrieve and run the cached code instead of regenerating it—saving time and tokens.

## Setup

Get your API key from the [Raysurfer dashboard](https://raysurfer.com/dashboard/api-keys) and configure it:

```bash
# Via environment variable
export RAYSURFER_API_KEY=your_api_key_here

# Or via OpenClaw config
openclaw config set skills.entries.code-cache.apiKey "your_api_key_here"
```

## Available Commands

### Search for cached code

```
/code-cache search <task description> [--top-k N] [--min-score FLOAT] [--show-code]
```

Search for cached code snippets that match a natural language task description.

**Options:**
- `--top-k N` — Maximum number of results (default: 5)
- `--min-score FLOAT` — Minimum verdict score filter (default: 0.3)
- `--show-code` — Display the source code of the top match

**Example:**
```
/code-cache search "Generate a quarterly revenue report"
/code-cache search "Fetch GitHub trending repos" --top-k 3 --show-code
```

### Get code files for a task

```
/code-cache files <task description> [--top-k N] [--cache-dir DIR]
```

Retrieve code files ready for execution, with a pre-formatted prompt addition for your LLM.

**Options:**
- `--top-k N` — Maximum number of files (default: 5)
- `--cache-dir DIR` — Output directory (default: `.code_cache`)

**Example:**
```
/code-cache files "Fetch GitHub trending repos"
/code-cache files "Build a chart" --cache-dir ./cached_code
```

### Upload code to cache

```
/code-cache upload <task> --files <path> [<path>...] [--failed] [--no-auto-vote]
```

Upload code from an execution to the cache for future reuse.

**Options:**
- `--files, -f` — Files to upload (required, can specify multiple)
- `--failed` — Mark the execution as failed (default: succeeded)
- `--no-auto-vote` — Disable automatic voting on stored code blocks

**Example:**
```
/code-cache upload "Build a chart" --files chart.py
/code-cache upload "Data pipeline" -f extract.py transform.py load.py
/code-cache upload "Failed attempt" --files broken.py --failed
```

### Vote on cached code

```
/code-cache vote <code_block_id> [--up|--down] [--task TEXT] [--name TEXT] [--description TEXT]
```

Vote on whether cached code was useful. This improves retrieval quality over time.

**Options:**
- `--up` — Upvote / thumbs up (default)
- `--down` — Downvote / thumbs down
- `--task` — Original task description (optional)
- `--name` — Code block name (optional)
- `--description` — Code block description (optional)

**Example:**
```
/code-cache vote abc123 --up
/code-cache vote xyz789 --down --task "Generate report"
```

## How It Works

1. **Cache Hit**: When you ask for code similar to something previously executed, Code Cache returns the cached version instantly
2. **Cache Miss**: When no match exists, your agent generates code normally, then Code Cache stores it for future use
3. **Verdict Scoring**: Code that works gets 👍, code that fails gets 👎—retrieval improves over time

## API Reference

The skill wraps these Raysurfer API methods:

| Method | Description |
|--------|-------------|
| `search(task, top_k, min_verdict_score)` | Unified search for cached code snippets |
| `get_code_files(task, top_k, cache_dir)` | Get code files ready for sandbox execution |
| `upload_new_code_snips(task, files_written, succeeded, auto_vote)` | Store new code after execution |
| `vote_code_snip(task, code_block_id, code_block_name, code_block_description, succeeded)` | Vote on snippet usefulness |

## Why Code Caching?

LLM agents repeat the same patterns constantly. Instead of regenerating code every time:

- **30x faster**: Retrieve proven code instead of waiting for generation
- **Lower costs**: Reduce token usage by reusing cached solutions  
- **Higher quality**: Cached code has been validated and voted on
- **Consistent output**: Same task = same proven solution

Learn more at [raysurfer.com](https://raysurfer.com) or read the [documentation](https://docs.raysurfer.com).
