# CNKI 专业检索查询案例

## 基础案例

### 案例1：单一主题检索

**需求**：检索关于"结膜松弛"的文献

**查询语句**：
```
SU='结膜松弛'
```

**说明**：使用 SU（主题）字段进行精确匹配检索

---

### 案例2：多主题AND检索

**需求**：检索关于"结膜松弛的治疗"的文献

**查询语句**：
```
SU='结膜松弛' and SU='治疗'
```

**说明**：检索同时包含"结膜松弛"和"治疗"两个主题词的文献

---

### 案例3：多主题OR检索

**需求**：检索关于"结膜松弛"或" conjunctivochalasis"的文献

**查询语句**：
```
SU='结膜松弛' or SU='conjunctivochalasis'
```

**说明**：检索包含任一主题词的文献（包括中英文）

---

## 进阶案例

### 案例4：混合逻辑运算

**需求**：检索关于结膜松弛的治疗或手术方法的文献

**查询语句**：
```
SU='结膜松弛' and (SU='治疗' or SU='手术')
```

**说明**：优先处理括号内的 OR 条件，再与前面的主题词结合

---

### 案例5：排除检索

**需求**：检索关于结膜松弛的治疗，但排除预防相关的文献

**查询语句**：
```
SU='结膜松弛' and SU='治疗' - SU='预防'
```

**说明**：使用减号排除包含"预防"的文献

---

### 案例6：指定作者检索

**需求**：检索张兴儒作者关于结膜松弛的文献

**查询语句**：
```
AU='张兴儒' and SU='结膜松弛'
```

**说明**：精确匹配作者姓名，并限定主题词

---

### 案例7：模糊作者检索

**需求**：检索所有姓张的作者关于结膜松弛的文献

**查询语句**：
```
AU%'张' and SU='结膜松弛'
```

**说明**：使用 % 进行模糊匹配

---

### 案例8：作者单位检索

**需求**：检索复旦大学关于结膜松弛的文献

**查询语句**：
```
AF='复旦大学' and SU='结膜松弛'
```

**说明**：精确匹配作者单位

---

### 案例9：篇名检索

**需求**：检索标题包含"结膜松弛症"的文献

**查询语句**：
```
TI='结膜松弛症'
```

**说明**：仅在标题字段中检索

---

### 案例10：关键词检索

**需求**：检索关键词包含"手术治疗"的文献

**查询语句**：
```
KY='手术治疗'
```

**说明**：仅在关键词字段中检索

---

## 高级案例

### 案例11：篇关摘全文检索

**需求**：检索全文包含"手术"和"结膜"的文献

**查询语句**：
```
TKA='结膜' * '手术'
```

**说明**：在标题、关键词、摘要中检索，可使用 * 代替 and

---

### 案例12：基金文献检索

**需求**：检索国家自然科学基金资助的关于结膜松弛的文献

**查询语句**：
```
FU='国家自然科学基金' and SU='结膜松弛'
```

**说明**：限定为特定基金资助的文献

---

### 案例13：引用次数筛选

**需求**：检索被引用次数大于10次的结膜松弛相关文献

**查询语句**：
```
SU='结膜松弛' and CF>10
```

**说明**：使用数值比较运算符筛选高被引文献

---

### 案例14：时间范围检索

**需求**：检索2020-2024年发表的结膜松弛相关文献

**查询语句**：
```
SU='结膜松弛' and (PT='2020' or PT='2021' or PT='2022' or PT='2023' or PT='2024')
```

**说明**：使用或运算限定年份范围（需在高级检索界面设置时间）

---

### 案例15：复合字段检索

**需求**：检索张兴儒或李青松作为作者的结膜松弛相关文献

**查询语句**：
```
(AU='张兴儒' or AU='李青松') and SU='结膜松弛'
```

**说明**：组合使用括号和或运算

---

## 医学眼科专题案例

### 案例16：眼科疾病治疗研究

**需求**：检索眼科领域中关于结膜松弛症治疗的中文文献

**查询语句**：
```
SU='结膜松弛' and SU='治疗' and CLC=R779.6
```

**说明**：结合主题词和学科分类（眼科医学 R779.6）

---

### 案例17：中西医结合治疗

**需求**：检索中西医结合治疗结膜松弛的文献

**查询语句**：
```
SU='结膜松弛' and SU='中西医结合'
```

**说明**：检索特定治疗方法的相关文献

---

### 案例18：特定手术方法

**需求**：检索关于新月形切除术治疗结膜松弛的文献

**查询语句**：
```
SU='结膜松弛' and (SU='新月形切除' or SU='巩膜固定术')
```

**说明**：检索特定手术方法的相关文献

---

### 案例19：中医药治疗

**需求**：检索中医药治疗结膜松弛的文献（如杞精明目汤）

**查询语句**：
```
SU='结膜松弛' and SU='杞精明目汤'
```

**说明**：检索中医药治疗的相关文献

---

### 案例20：高被引文献

**需求**：检索被引用次数超过50次的结膜松弛经典文献

**查询语句**：
```
SU='结膜松弛' and CF>50
```

**说明**：筛选高影响力文献

---

## 英文检索案例

### 案例21：英文主题词检索

**需求**：检索英文文献 "conjunctivochalasis treatment"

**查询语句**：
```
SU='conjunctivochalasis' and SU='treatment'
```

**说明**：使用英文主题词进行检索

---

### 案例22：中英文扩展检索

**需求**：检索包含"结膜松弛"或"conjunctivochalasis"的文献

**查询语句**：
```
SU='结膜松弛' or SU='conjunctivochalasis'
```

**说明**：可在高级检索中勾选"中英文扩展"选项

---

## 期刊来源限定

### 案例23：特定期刊检索

**需求**：检索《中华眼科杂志》中关于结膜松弛的文献

**查询语句**：
```
LY='中华眼科杂志' and SU='结膜松弛'
```

**说明**：限定文献来源为特定期刊

---

### 案例24：核心期刊检索

**需求**：检索北大核心期刊收录的结膜松弛相关文献

**查询语句**：
```
SU='结膜松弛' and LY in (中华眼科杂志, 中华实验和临床感染病杂志, 中国实用眼科杂志)
```

**说明**：限定在核心期刊范围内检索

---

## 常见错误与修正

### 错误1：遗漏引号

❌ 错误：`SU=结膜松弛`
✅ 正确：`SU='结膜松弛'`

### 错误2：运算符使用不当

❌ 错误：`SU='结膜松弛' && SU='治疗'`
✅ 正确：`SU='结膜松弛' and SU='治疗'`

### 错误3：括号位置错误

❌ 错误：`SU='结膜松弛' and SU='治疗' or SU='手术'`
✅ 正确：`SU='结膜松弛' and (SU='治疗' or SU='手术')`

### 错误4：字段代码错误

❌ 错误：`SUB='结膜松弛'`
✅ 正确：`SU='结膜松弛'`

---

## 快速查询模板

| 需求类型 | 查询模板 |
|----------|----------|
| 主题检索 | `SU='关键词'` |
| 主题+治疗 | `SU='关键词1' and SU='关键词2'` |
| 作者+主题 | `AU='作者名' and SU='关键词'` |
| 单位+主题 | `AF='单位名' and SU='关键词'` |
| 篇名检索 | `TI='标题词'` |
| 全文检索 | `FT='关键词'` |
| 高被引 | `SU='关键词' and CF>10` |