# CNKI 专业检索字段一览表

## 常用字段

| 字段代码 | 字段名称 | 说明 | 示例 |
|----------|----------|------|------|
| SU | 主题 | 检索主题词，包含标题、关键词、摘要 | SU='结膜松弛' |
| TI | 篇名 | 检索文献标题 | TI='结膜松弛症' |
| KY | 关键词 | 检索文献关键词 | KY='手术治疗' |
| AB | 摘要 | 检索文献摘要 | AB='治疗方法' |
| AU | 作者 | 检索作者姓名 | AU='张兴儒' |
| AF | 作者单位 | 检索作者所属机构 | AF='北京大学' |
| FI | 第一作者 | 检索第一作者 | FI='李青松' |
| RP | 通讯作者 | 检索通讯作者 | RP='张兴儒' |
| FU | 基金 | 检索基金项目 | FU='国家自然科学基金' |
| TKA | 篇关摘 | 检索标题、关键词、摘要 | TKA='结膜松弛' |
| FT | 全文 | 检索全文内容 | FT='手术治疗方法' |
| CO | 小标题 | 检索章节小标题 | CO='结论' |
| RF | 参考文献 | 检索参考文献 | RF='临床研究' |
| LY | 文献来源 | 检索期刊/会议/报纸名称 | LY='中华眼科杂志' |
| CLC | 分类号 | 检索中国图书馆分类号 | CLC=R779.6 |
| DOI | DOI | 检索DOI号 | DOI=10.1234 |
| CF | 被引频次 | 按引用次数筛选 | CF>=10 |

## 逻辑运算符

| 运算符 | 说明 | 示例 |
|--------|------|------|
| and | 逻辑与，两个条件都满足 | A and B |
| or | 逻辑或，满足任一条件即可 | A or B |
| * 或 and | 逻辑与 | A * B 或 A and B |
| + 或 or | 逻辑或 | A + B 或 A or B |
| - | 逻辑非，排除包含某词的内容 | A - B |
| () | 括号优先级 | (A or B) and C |

## 关系运算符

| 运算符 | 说明 | 示例 |
|--------|------|------|
| = | 精确匹配 | AU='张三' |
| % | 模糊匹配 | AU%'张' |
| == | 精确匹配（与=相同） | AU=='张三' |
| <> | 不等于 | AU<>'李四' |
| > < >= <= | 数值比较 | CF>10 |

## 位置运算符

| 运算符 | 说明 | 示例 |
|--------|------|------|
| in | 在指定字段中检索 | AU in (张三, 李四) |
| not in | 不在指定字段中检索 | KY not in (眼科, 手术) |

## 组合检索示例

```cnki
# 基本精确检索
SU='结膜松弛'

# 多字段AND检索
SU='结膜松弛' and SU='治疗'

# 多字段OR检索
SU='结膜松弛' or SU=' conjunctivochalasis'

# 混合逻辑
SU='结膜松弛' and (SU='治疗' or SU='手术')

# 排除检索
SU='结膜松弛' - SU='预防'

# 模糊匹配
AU%'张'

# 数值范围
CF>=5 and CF<=20
```

## 字段修饰符

| 修饰符 | 说明 | 示例 |
|--------|------|------|
| $C | 精确匹配 | TI$C='结膜松弛' |
| $D | 包含 | TI$D='结膜' |
| $F | 字段内匹配 | AU$F='张' |

## 常用字段组合

| 检索目的 | 推荐字段组合 |
|----------|--------------|
| 主题研究 | SU（主题） |
| 标题+摘要 | TI or AB |
| 篇关摘 | TKA |
| 全文检索 | FT |
| 作者+单位 | AU and AF |
| 基金文献 | FU |

## 符号说明

- **单引号 ' '**：用于精确短语检索
- **双引号 " "**：同单引号
- **括号 ()**：改变运算优先级
- **逗号 ,**：在列表中表示"或"关系

## 注意事项

1. 字段代码不区分大小写
2. 字符串值需用单引号括起来
3. 逻辑运算符优先级：NOT > AND > OR
4. 使用括号明确优先级，避免歧义
5. 建议使用 SU 字段进行主题检索，覆盖面更广