# Marketing Operations

## Marketing Tech Stack

### Core Stack

| Function | Tools |
|----------|-------|
| CRM | Salesforce, HubSpot |
| Marketing automation | HubSpot, Marketo, Pardot |
| Analytics | GA4, Mixpanel, Amplitude |
| Attribution | Dreamdata, Bizible, HockeyStack |
| SEO | Ahrefs, Semrush, Clearscope |
| Social | Hootsuite, Buffer, Sprout |
| Email | Customer.io, Klaviyo, Mailchimp |
| Ads | Platform native + reporting tools |

### Selection Criteria
- Integration with existing stack
- Team capability to use it
- Total cost (including implementation)
- Scalability for growth
- Vendor stability

## Dashboard Design

### Executive Dashboard
- Pipeline influenced by marketing
- CAC and CAC payback
- Channel efficiency (cost per MQL/SQL)
- Brand metrics (if tracking)

### Operational Dashboard
- Traffic and conversion by channel
- Lead volume and velocity
- Campaign performance
- Content engagement

### Update Cadence
- Real-time: Alerts for anomalies
- Daily: Operational metrics
- Weekly: Campaign performance
- Monthly: Strategic review

## Team Structure

### Functional Model

| Function | Responsibilities |
|----------|------------------|
| Brand | Positioning, creative, PR |
| Demand gen | Campaigns, paid, events |
| Content | Editorial, SEO, social |
| Product marketing | Messaging, launches, enablement |
| Marketing ops | Tech, data, process |

### By Stage

| Stage | Team |
|-------|------|
| Seed | Generalist marketer + freelancers |
| Series A | Head of marketing + 2-3 specialists |
| Series B | CMO + managers per function |
| Series C+ | Full teams per function |

## Agency Management

### When to Use Agencies
- Specialized skills you don't have
- Spike capacity needs
- Testing before hiring
- Creative refresh

### When to Build In-House
- Core strategic work
- Daily operations
- Tribal knowledge critical
- Long-term cost efficiency

### Working With Agencies
- Clear briefs and success metrics
- Regular check-ins (weekly minimum)
- Access to data and feedback
- Defined handoff processes
- Performance reviews quarterly

## Budget Allocation

### Rule of Thumb by Stage

| Stage | % of Revenue | Focus |
|-------|--------------|-------|
| Pre-revenue | Fixed amount | Experiments |
| Early | 30-50% | Growth at all costs |
| Growth | 15-25% | Efficient scaling |
| Scale | 10-15% | Optimization |

### Budget Split
- 60-70% proven channels (performance)
- 20-30% experiments (new channels, big bets)
- 10% brand (compounds over time)
