# Demand Generation

## Full-Funnel Framework

| Stage | Goal | Metrics |
|-------|------|---------|
| Awareness | Know we exist | Traffic, impressions, reach |
| Consideration | Understand value | Engagement, content consumption |
| Decision | Choose us | MQLs, SQLs, pipeline |
| Retention | Stay and grow | NPS, expansion, referrals |

## Channel Selection

### Prioritization Criteria

| Factor | Questions |
|--------|-----------|
| Audience presence | Is ICP actually there? |
| Intent signal | Can we capture demand? |
| Cost to test | Minimum viable experiment? |
| Scalability | Can it grow with us? |
| Competition | How saturated is it? |

### Channel Matrix

| Channel | Best For | Time to Results |
|---------|----------|-----------------|
| Paid search | High intent, bottom funnel | Days |
| Paid social | Awareness, top funnel | Weeks |
| SEO/Content | Compounding, mid-funnel | Months |
| Email | Nurture, retention | Ongoing |
| Events | Relationships, enterprise | Months |
| Partnerships | Distribution, credibility | Months |

## Lead Scoring

### Fit + Engagement Model

| Score | Fit (ICP match) | Engagement (behavior) |
|-------|-----------------|----------------------|
| A | Perfect ICP | High engagement |
| B | Good ICP | Medium engagement |
| C | Partial ICP | Low engagement |
| D | Poor fit | Any engagement |

**MQL threshold:** A1, A2, B1 typically

### Scoring Factors

| Fit Factors | Engagement Factors |
|-------------|-------------------|
| Company size | Page views |
| Industry | Content downloads |
| Title/role | Email opens/clicks |
| Technology | Demo requests |
| Geography | Pricing page visits |

## Campaign Planning

### Campaign Brief Template

```
Objective: [Specific, measurable goal]
Audience: [Segment definition]
Message: [Key value proposition]
Channels: [Where we'll reach them]
Timeline: [Start, key dates, end]
Budget: [Total and by channel]
Success metrics: [Primary and secondary]
```

## Attribution

### Models

| Model | Logic | Use When |
|-------|-------|----------|
| First touch | Credit to first interaction | Understanding awareness |
| Last touch | Credit to final interaction | Simple, direct response |
| Linear | Equal credit to all touches | Long, complex journeys |
| Time decay | More credit to recent touches | Balanced view |
| Custom | Weighted by your logic | Mature programs |

**Reality:** No model is perfect. Use multiple views.
