# Content Strategy

## Content Pillars

Define 3-5 themes that:
- Align with product value props
- Match audience pain points
- You can credibly own
- Have search/social demand

### Example Structure

| Pillar | Topics | Formats |
|--------|--------|---------|
| Revenue operations | Forecasting, pipeline, metrics | Guides, tools |
| Sales leadership | Hiring, coaching, process | Interviews, frameworks |
| Growth strategy | GTM, expansion, PLG | Case studies, research |

## Content Formats

| Format | Best For | Effort |
|--------|----------|--------|
| Blog posts | SEO, thought leadership | Low-medium |
| Guides/ebooks | Lead gen, depth | Medium-high |
| Videos | Engagement, social | Medium-high |
| Podcasts | Relationships, reach | Medium |
| Webinars | Lead gen, demos | Medium |
| Tools/calculators | Lead gen, utility | High |
| Case studies | Bottom funnel, proof | Medium |

## Content Repurposing

One piece of content → multiple formats:

```
Webinar recording
    → Blog post summary
    → Video clips for social
    → Podcast episode
    → Quote graphics
    → Email series
    → Slide deck
```

**Rule:** Create once, distribute everywhere.

## Editorial Calendar

### Cadence by Stage

| Stage | Blog | Long-form | Video |
|-------|------|-----------|-------|
| Early | 1-2/week | 1/month | As needed |
| Growth | 3-4/week | 2-3/month | Weekly |
| Scale | Daily | Weekly | Daily |

### Calendar Elements

- Publish date
- Content type
- Topic/title
- Target keyword
- Author/owner
- Status
- Distribution channels
- Associated campaign

## SEO Fundamentals

### On-Page Checklist
- [ ] Target keyword in title, H1, URL
- [ ] Meta description with keyword
- [ ] Headers structured (H1 → H2 → H3)
- [ ] Internal links to related content
- [ ] Image alt text
- [ ] Mobile-friendly
- [ ] Fast page load

### Content Clusters

```
Pillar Page (broad topic, high volume)
    ↓
Cluster Pages (specific subtopics)
    ↓
Internal Links (connect everything)
```

## Distribution Checklist

After publishing:
- [ ] Share on social channels
- [ ] Email to newsletter list
- [ ] Post in relevant communities
- [ ] Send to internal team to share
- [ ] Pitch for external syndication
- [ ] Repurpose for other formats
- [ ] Add to nurture sequences
