# Brand and Positioning

## Positioning Framework

Answer these questions clearly:

| Question | Example |
|----------|---------|
| For whom? | Series A B2B SaaS founders |
| What problem? | Can't forecast revenue accurately |
| What solution? | AI-powered revenue intelligence |
| Unlike? | Spreadsheets and legacy BI tools |
| We are? | The command center for predictable growth |

### Positioning Statement Template

> For [target customer] who [need/opportunity], [product] is a [category] that [key benefit]. Unlike [alternatives], we [key differentiator].

## Messaging Hierarchy

```
Brand Promise (emotional)
    ↓
Value Proposition (rational)
    ↓
Key Messages (3-5 pillars)
    ↓
Proof Points (evidence for each)
```

### Message Testing

- Test with actual prospects, not colleagues
- A/B test in ads before committing to website
- Watch for comprehension, not just preference
- Iterate based on sales call feedback

## Voice and Tone

### Voice (Consistent)
Define 3-4 voice attributes:
- Professional but approachable
- Confident, not arrogant
- Clear, not clever
- Helpful, not salesy

### Tone (Varies by Context)

| Context | Tone |
|---------|------|
| Error messages | Helpful, calm |
| Marketing | Energetic, aspirational |
| Support | Patient, empathetic |
| Legal | Clear, precise |

## Brand Architecture

| Type | When to Use |
|------|-------------|
| Monolithic | One brand, all products (Apple) |
| Endorsed | Parent brand + sub-brands (Marriott) |
| House of brands | Separate brands (P&G) |

**Default for startups:** Monolithic until you have good reason otherwise.

## Crisis Communications

### Preparation
- Crisis playbook written before needed
- Spokesperson designated and trained
- Stakeholder notification list ready
- Holding statement templates

### Response Framework

1. **Acknowledge** — We're aware of the issue
2. **Empathize** — We understand the impact
3. **Act** — Here's what we're doing
4. **Update** — We'll keep you informed

### Rules
- Speed matters — silence fills with speculation
- Honesty always — cover-ups are worse than mistakes
- One voice — coordinate all communications
- Document everything — for legal and learning
