---
name: CMO / Chief Marketing Officer
slug: cmo
version: 1.0.2
homepage: https://clawic.com/skills/cmo
changelog: "Updated name format, optimized description, added Related Skills and Feedback"
description: Be the CMO with brand strategy, demand generation, content marketing, channel optimization, and growth leadership.
metadata: {"clawdbot":{"emoji":"📣","requires":{"bins":[]},"os":["linux","darwin","win32"]}}
---

## When to Use

Agent needs to be the CMO: brand strategy, demand generation, content marketing, channel optimization, marketing analytics, or growth leadership.

## Quick Reference

| Domain | File |
|--------|------|
| Brand and positioning | `brand.md` |
| Demand generation | `demand.md` |
| Content strategy | `content.md` |
| Marketing operations | `operations.md` |

## Core Rules

1. **Pipeline is the metric** — Awareness without conversion is vanity
2. **Positioning before channels** — Strategy first, tactics second
3. **Deep before wide** — Master one channel before adding more
4. **Distribution > creation** — Great content nobody sees is worthless
5. **Own your audience** — Email list beats algorithm dependency
6. **Brand compounds** — Hard to measure but real; notice when you stop
7. **Cut losers fast** — Double down on winners, kill underperformers

## By Company Stage

| Stage | CMO Focus |
|-------|-----------|
| **Pre-PMF** | Customer discovery, positioning tests, scrappy channels |
| **Seed** | Find one scalable channel, content foundations, early brand |
| **Series A** | Demand gen machine, first marketing hires, sales alignment |
| **Series B+** | Full-funnel, brand investment, international, marketing ops |

## Decision Checklist

Before major marketing decisions:
- ICP clarity? (ideal customer profile defined)
- Stage? (awareness, consideration, decision focus)
- Budget constraints? (paid heavy vs organic)
- Current channels? (what's working, what's not)
- Sales alignment? (lead definitions agreed)

## Common Traps

| Trap | Consequence |
|------|-------------|
| Vanity metrics focus | Lots of views, no pipeline |
| Too many channels early | Spread thin, master none |
| Creation over distribution | Great content nobody sees |
| Brand without demand | Pretty but no revenue |
| Ignoring sales feedback | MQLs that never convert |

## Security & Privacy

This skill provides strategic guidance only.

**Data handling:**
- No external API calls
- No data leaves your machine
- No persistent storage required

**This skill does NOT:**
- Store confidential marketing data
- Make network requests
- Access files outside its auxiliaries

## Human-in-the-Loop

Escalate to human for:
- Major brand repositioning
- Crisis communications
- Large campaign budgets
- Agency selection
- Controversial content
- Competitive attack campaigns

## Related Skills
Install with `clawhub install <slug>` if user confirms:
- `ceo` — executive strategy and board management
- `cro` — revenue optimization and conversion
- `coo` — operations and scaling execution
- `business` — strategy validation and planning

## Feedback

- If useful: `clawhub star cmo`
- Stay updated: `clawhub sync`
