---
name: cloudphone
description: Use mcporter to call cpc-mcp-server AutoJS Agent tools for cloud Android task execution and result retrieval.
metadata:
  {
    "openclaw":
      {
        "emoji": "📱",
        "requires":
          { "bins": ["mcporter"], "env": ["CLOUDPHONE_API_KEY"] },
        "install":
          [
            {
              "id": "node",
              "kind": "node",
              "package": "mcporter",
              "bins": ["mcporter"],
              "label": "Install mcporter (node)",
            },
          ],
        "primaryEnv": "CLOUDPHONE_API_KEY",
      },
  }
---

## What this skill does

`cloudphone` guides the agent to run Android automation tasks in a cloud phone environment by calling `cpc-mcp-server` tools through `mcporter`.

It is designed for:
- AutoJS-based cloud phone automation
- App regression / smoke test execution
- Remote batch operation workflows
- Scripted interaction on cloud Android devices

---

## When to use this skill

Use this skill when the user asks for actions such as:
- “Run a script on a cloud phone”
- “Use AutoJS to automate this app flow”
- “Execute Android UI steps remotely and return screenshots/logs”
- “Use cpc-mcp-server for cloud-device automation”

---

## When NOT to use this skill

Do not use this skill for:
- Local ADB/emulator automation (non-cloud devices)
- iOS automation (e.g., XCUITest)
- Static script/code review without real device execution
- Pure consulting requests without executable task goals

---

## Required prerequisites (must pass before execution)

Before any call, ensure authentication is configured correctly.

`cpc-mcp-server` requires:

- `Authorization: Bearer <API_KEY>`

This skill standardizes the API key through:

- `CLOUDPHONE_API_KEY` (required)

### Requirements

1. Set environment variable `CLOUDPHONE_API_KEY`.
2. Ensure MCP server header injection is active before execution:
   - `Authorization: Bearer $CLOUDPHONE_API_KEY`
3. Never hardcode or commit real keys in repo files, `SKILL.md`, or config JSON.

> This skill defines naming and preconditions only.  
> Secret injection implementation is handled by runtime/environment config.

---

## Invocation model (via mcporter)

This skill does not call MCP tools directly. It uses `mcporter` CLI to invoke tools on `cpc-mcp-server`.

Common command patterns:
- List configured MCP servers:
  - `mcporter list`
- Inspect server schema:
  - `mcporter list cpc-mcp-server --schema`
- Call tool with JSON args (recommended):
  - `mcporter call cpc-mcp-server.<tool> --args '<json>'`

> Prefer `--args` JSON for long instructions, multilingual text, and special characters.

---

## Minimal input checklist (before creating tasks)

Collect these fields first (ask follow-up only if missing):
1. Target app (name/package)
2. Intended action (what to do)
3. Success criteria (what counts as done)
4. Expected output type (screenshot/log/text result)

---

## Tool 1: Create task (`createAutoJsAgentTask`)

### Goal
Create and dispatch an AutoJS Agent task, then obtain `taskId` (and possibly `sessionId`).

### Recommended call

```bash
mcporter call cpc-mcp-server.createAutoJsAgentTask --args '{
  "instruction": "Open <APP_NAME> on cloud phone, log in with test account, navigate to Orders page, capture a screenshot, and return order count.",
  "lang": "en"
}'
