---
name: cloudflare-r2
description: Upload files to Cloudflare R2 storage using wrangler CLI. Use when needing to upload images, videos, or files to R2 for CDN hosting, or manage R2 bucket contents. Triggers on "upload to R2", "upload to Cloudflare", "上传到R2", "存到CDN".
metadata:
  {"openclaw": {"requires": {"bins": ["wrangler"]}, "install": [{"id": "node", "kind": "node", "package": "wrangler", "bins": ["wrangler"], "label": "Install Wrangler CLI (npm)"}]}}
---

# Cloudflare R2

Upload and manage files in Cloudflare R2 storage buckets.

## Prerequisites

- `wrangler` CLI: `npm install -g wrangler`
- R2 config at `~/.config/cloudflare/r2.json`

## Config Format

```json
{
  "bucket": "your-bucket-name",
  "accountId": "your-account-id",
  "publicDomain": "pub-xxx.r2.dev",
  "apiToken": "your-api-token"
}
```

## Quick Upload

Single file:
```bash
scripts/r2-upload.sh <local-file> [remote-path]
```

Batch upload:
```bash
scripts/r2-upload.sh <directory> <remote-prefix>
```

## Manual Commands

```bash
# Set credentials
export CLOUDFLARE_ACCOUNT_ID="$(jq -r .accountId ~/.config/cloudflare/r2.json)"
export CLOUDFLARE_API_TOKEN="$(jq -r .apiToken ~/.config/cloudflare/r2.json)"
BUCKET=$(jq -r .bucket ~/.config/cloudflare/r2.json)

# Upload
wrangler r2 object put "$BUCKET/path/to/file.png" --file local.png --remote

# List objects
wrangler r2 object list $BUCKET --prefix "path/" --remote

# Delete
wrangler r2 object delete "$BUCKET/path/to/file.png" --remote
```

## Public URL

After upload, files are accessible at:
```
https://<publicDomain>/<remote-path>
```

Example: `https://pub-xxx.r2.dev/article/image.png`
