---
name: cloudflare-manager
description: Manage Cloudflare DNS records, Tunnels (cloudflared), and Zero Trust policies. Use for pointing domains, exposing local services via tunnels, and updating ingress rules.
metadata: {"openclaw":{"requires":{"bins":["python3","cloudflared"],"env":["CLOUDFLARE_API_TOKEN","CLOUDFLARE_ZONE_ID"]},"install":[{"id":"cf-setup","kind":"exec","command":"bash scripts/install.sh"}]}}
---

# Cloudflare Manager

Standardized system for managing Cloudflare infrastructure and local tunnel ingress.

## Prerequisites
- **Binary**: `python3` and `cloudflared` must be installed.
- **Credentials**: `CLOUDFLARE_API_TOKEN` (minimal Zone permissions) and `CLOUDFLARE_ZONE_ID`.

## Setup
1. Define credentials in the environment or a local `.env` file.
2. Initialize the local environment: `bash scripts/install.sh`.

## Core Workflows

### 1. DNS Management
Add, list, or delete DNS records via Cloudflare API.
- **List**: `python3 $WORKSPACE/skills/cloudflare-manager/scripts/cf_manager.py list-dns`
- **Add**: `python3 $WORKSPACE/skills/cloudflare-manager/scripts/cf_manager.py add-dns --type A --name <subdomain> --content <ip>`

### 2. Tunnel Ingress (Local)
Update `/etc/cloudflared/config.yml` and restart the tunnel service.
- **Update**: `python3 $WORKSPACE/skills/cloudflare-manager/scripts/cf_manager.py update-ingress --hostname <host> --service <url>`
- **Safety**: Use `--dry-run` to preview configuration changes before application.

## Security & Permissions
- **Sudo Usage**: The `update-ingress` command requires `sudo` to write to system directories and restart the `cloudflared` service.
- **Least Privilege**: Configure restricted sudo access using the pattern in `references/sudoers.example`.
- **Token Isolation**: Ensure API tokens are scoped narrowly to specific zones and permissions.

## Reference
- **Sudoers Pattern**: See [references/sudoers.example](references/sudoers.example).
- **Tunnel Logic**: See [references/tunnel-guide.md](references/tunnel-guide.md).
