# Sharing Files in the Cloud

## Quick Reference

| Situation | Best approach |
|-----------|---------------|
| Send a file once to anyone | Share link (with expiration) |
| Collaborate on a document | Shared folder or live doc |
| Family photo sharing | Shared album or folder |
| Send to someone who's not tech-savvy | Email attachment (under 25 MB) |
| Sensitive document | Don't share via cloud, or encrypt first |

## iCloud

**Share a file/folder:**
1. Find file in Files app or iCloud.com
2. Tap Share → Share File/Folder
3. Choose: "Anyone with the link" or "Only people you invite"
4. Set permissions: "Can make changes" or "View only"

**Shared Album (photos):**
1. Photos app → Albums → Create Shared Album
2. Add people by email/phone
3. They can add photos too (if allowed)

**Stop sharing:**
- Click shared item → Share → Manage Shared File → Remove Access

**Gotcha:** iCloud links require recipients to have Apple ID to edit (viewing works for anyone).

## Google Drive

**Share a file/folder:**
1. Right-click → Share
2. Add people by email (they get access directly)
3. OR click "Get link" → Change to "Anyone with link"
4. Set role: Viewer, Commenter, or Editor

**Link settings:**
- "Restricted" = only specific people
- "Anyone with link" = anyone who has the URL
- Set expiration date in advanced settings

**Stop sharing:**
- Right-click → Share → Remove people or turn off link

**Gotcha:** Files shared with you appear in "Shared with me", not "My Drive" unless you add them.

## Dropbox

**Share a file/folder:**
1. Right-click file → Share
2. Enter emails OR create a link
3. Choose "Can edit" or "Can view"

**Link settings:**
- Set password (paid plans)
- Set expiration (paid plans)
- Disable downloads (view only)

**Shared folder:**
- The folder appears in everyone's Dropbox
- Changes sync for everyone
- Leaving the folder removes it from your Dropbox (doesn't delete for others)

**Stop sharing:**
- Settings icon on shared link → Delete link

## OneDrive

**Share a file/folder:**
1. Right-click → Share
2. Choose "Anyone with the link" or "Specific people"
3. Set permissions and optional password/expiration

**Link options:**
- Allow editing on/off
- Block download
- Set expiration date

**Stop sharing:**
- Click "Manage access" → remove people or links

**Gotcha:** Work vs Personal OneDrive have different sharing rules. Work may be restricted by IT policy.

## Permission Levels Explained

| Level | What they can do |
|-------|-----------------|
| Viewer | See the file, download it |
| Commenter | View + leave comments (Google Docs) |
| Editor | View + modify + delete |
| Owner | Full control, can reshare, transfer ownership |

**Rule of thumb:** Give minimum needed. Start with Viewer, upgrade if needed.

## Security Tips

- **Set expiration on links** — one-time shares shouldn't live forever
- **Review sharing quarterly** — remove old access
- **Don't share entire drives** — share specific folders
- **Password-protect sensitive files** — when available
- **For truly sensitive docs** — send via secure message, not cloud link
