# Freeing Up Cloud Storage

## iCloud

1. **Check usage:** Settings → [Your Name] → iCloud → Manage Storage
2. **Photos usually dominate:** 
   - Delete blurry/duplicate photos
   - Empty "Recently Deleted" album
3. **Old backups:** Delete backups of devices you no longer own
4. **Messages:** iCloud stores all iMessage history. Delete old conversations or turn off Messages in iCloud.
5. **App data:** Some apps store gigabytes. Review and delete unused app data.

**Nuclear option:** Settings → iCloud → Photos → turn off, delete from iCloud (keep on device), then re-enable with "Optimize Storage"

## Google Drive

1. **Check usage:** drive.google.com/settings/storage
2. **Remember:** Storage is shared with Gmail and Photos
3. **Find large files:** drive.google.com → Storage → click to sort by size
4. **Gmail attachments count:** Search `has:attachment larger:10M` in Gmail, delete old emails
5. **Google Photos:** photos.google.com → Trash → Empty
6. **Shared files don't count** — but files in your Trash do

**Quick win:** drive.google.com/drive/quota shows exactly what's using space

## Dropbox

1. **Check usage:** dropbox.com → Settings → Plan
2. **Deleted files:** dropbox.com → Deleted files → Permanently delete
3. **Shared folders:** Leaving a shared folder frees space
4. **Camera uploads:** Check if you're duplicating with another service
5. **Old file versions:** Contact support to purge version history if desperate

## OneDrive

1. **Check usage:** onedrive.com → Settings → Options → Manage Storage
2. **Recycle bin:** Files stay 93 days. Empty it.
3. **PC folders backup:** If enabled, Desktop/Documents/Pictures sync. Lots of hidden files.
4. **Shared libraries:** Work vs personal can be confusing. Check both.

## General Tips

- **Empty trash everywhere** — deleted ≠ gone until trash is emptied
- **Disable duplicate backups** — don't let Google Photos AND iCloud back up the same photos
- **Check "Recently Deleted"** on all services — files linger 30 days
- **Large files hide in random places** — use each service's storage analyzer
- **App data sneaks up** — WhatsApp backups, app caches, etc.

## When to Upgrade vs Clean

**Upgrade if:**
- You've cleaned and still need more
- Your time is worth more than $3/month
- You have important data that needs protection

**Clean if:**
- You're storing junk you'll never look at again
- You have duplicate backups running
- You haven't reviewed in over a year
