# Cloud Backup Strategy

## The 3-2-1 Rule

- **3** copies of important files
- **2** different storage types (cloud + local drive)
- **1** offsite copy (cloud counts)

Cloud is convenient but not bulletproof. A local backup protects against account lockouts, service shutdowns, or accidental deletion that syncs everywhere.

## What to Back Up

### High Priority (irreplaceable)
- Photos and videos (family memories)
- Important documents (tax returns, contracts, IDs)
- Creative work (writing, art, music you've created)
- Financial records

### Medium Priority (painful to recreate)
- Work documents
- School/research materials
- Downloaded purchases (PDFs, ebooks)
- App data you care about

### Low Priority (easily replaceable)
- Downloaded media you can re-download
- Old software installers
- Cache and temporary files

## What NOT to Store in Cloud (Unencrypted)

- **Passwords** — use a password manager instead
- **Bank account details** — too risky
- **ID scans** (passport, driver's license) — identity theft risk
- **Medical records** — privacy concern
- **Anything you'd be embarrassed to leak** — assume employees can see it

If you must store sensitive documents, encrypt them first (use a password-protected ZIP at minimum).

## Photo Backup Setup

**Pick ONE service:**
- iPhone users → iCloud Photos
- Android users → Google Photos
- Cross-platform → Google Photos or Dropbox

**Disable the others.** Multiple services = duplicates everywhere.

**Settings to enable:**
- Auto-upload over WiFi
- Optimize device storage (keeps originals in cloud, smaller versions on phone)

**Monthly check:**
- Open Photos app
- Scroll to bottom — should show "X photos, backed up"
- If not synced, check WiFi/settings

## Document Backup

**Desktop sync** (recommended):
- iCloud Drive, Google Drive, or OneDrive can sync your Desktop/Documents folders
- Every file you save is automatically backed up
- Works on Mac and Windows

**Gotcha:** If you disable sync later, files may be removed from cloud. Download first.

## Backup Checklist

- [ ] Photos auto-uploading to ONE service
- [ ] Documents folder syncing to cloud
- [ ] External hard drive backup (monthly is fine)
- [ ] 2FA enabled on all cloud accounts
- [ ] Verified backup works — can you access from another device?

## Recovery Test

Twice a year, pretend your phone/laptop is gone:

1. Log into cloud service from a different device
2. Find a specific photo from 6 months ago
3. Find a specific document you need
4. If you can't find them, your backup isn't working
