---
name: cloud-local-bridge
description: 实现云端 OpenClaw 与本地 OpenClaw 之间的双向通信桥接。支持自然语言配对、命令执行、文件同步。
---

# Cloud-Local Bridge

让云端和本地 OpenClaw 实例无缝协同，支持**自然语言配对**、**文件互通**、**命令远程执行**。

## 核心特性

✅ **自然语言配对** - 不用记指令，像聊天一样说"我想连接云端"
✅ **跨通道配对** - QQ/微信/Telegram/邮件都能完成配对
✅ **2步完成** - 像添加微信好友一样简单

## ⚡ 自然语言配对

### 直接发送自然语言

| 你发送 | 机器人回应 |
|--------|-----------|
| `配对` | 收到配对码 |
| `我想连接云端` | 收到配对码 |
| `添加设备` | 收到配对码 |
| `配对 847291` | 配对成功 |
| `查看配对` | 显示已连接设备 |
| `帮助配对` | 显示帮助 |

### 支持的自然语言

**发起配对：**
- `配对`、`我要配对`、`想配对`
- `连接`、`连接云端`、`连接本地`
- `添加设备`、`添加云端`、`添加好友`
- `关联设备`、`互相关联`
- `pair`、`connect`

**确认配对：**
- `配对 123456`

**查看状态：**
- `查看配对`、`配对状态`
- `我的设备`、`设备列表`

**取消：**
- `取消配对`、`删除设备`

## 📱 配对流程

```
用户 A（本地）                    用户 B（云端）
━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
1. 发送「我想连接云端」          (等待)
   ↓
2. 收到配对码: 847291
   ↓
3. 发送配给 B                  (接收配对码)
   ↓                          4. B 发送「配对 847291」
                                   ↓
5. ✅ 配对成功!                ✅ 配对成功!
```

## 🚀 快速启动

```bash
cd /root/.openclaw/workspace/skills/cloud-local-bridge/scripts

# 启动 Bridge 服务
python3 bridge_server.py --port 8080 --token "xxx"
```

## 🔧 组件说明

| 文件 | 说明 |
|------|------|
| `qq_handler.py` | 自然语言配对处理器 |
| `bridge_server.py` | Bridge 服务端 |
| `bridge_client.py` | Bridge 客户端 |
| `sync_files.py` | 文件同步 |

## 💡 使用场景

### 场景1：QQ 配对

```
你：我想连接云端
机器人：📱 发起配对成功！配对码：847291

（你把配对码发给云端用户）

云端用户：配对 847291
机器人：🎉 配对成功！已连接本地电脑
```

### 场景2：跨平台配对

```
本地（QQ）：配对 → 收到 582391 → 通过 QQ 发送给云端
云端（Telegram）：发送配对请求到 API → 配对成功
```

## 📁 文件结构

```
cloud-local-bridge/
├── SKILL.md
├── scripts/
│   ├── qq_handler.py        # 🆕 自然语言处理器
│   ├── bridge_server.py     # 服务端
│   ├── bridge_client.py    # 客户端
│   └── sync_files.py       # 文件同步
└── references/
    └── EXAMPLES.md
```

## ⚠️ 注意事项

- 配对码 10 分钟后过期
- 配对状态保存在 `~/.openclaw/bridge_pairing_state.json`
- 确保网络互通
