---
name: closing-deals
description: Close sales deals consistently as a solopreneur. Use when a prospect is at the decision stage and you need to move them to yes, when deals are stalling or going cold, when you need closing scripts or techniques, or when you want to build a repeatable process for turning proposals into signed contracts. Covers decision-stage psychology, closing techniques, stall recovery, contract-to-payment flow, and post-close relationship setup. Trigger on "how do I close a deal", "closing deals", "deal stalling", "prospect not responding", "how to get them to say yes", "close the sale", "convert proposal to client", "sales closing".
---

# Closing Deals

## Overview
Closing is not a moment — it's the result of everything that came before it. If you did discovery well, wrote a sharp proposal, and handled objections honestly, closing feels natural, almost obvious. This playbook covers what to do at the finish line: how to move a warm prospect to a signed contract, how to recover deals that stall, and how to set up the relationship so the first day as a client is as smooth as possible.

---

## Step 1: Recognize the Buying Signals

Before you close, you need to know they're ready. Pushing a close on someone who isn't there yet damages trust. Watch for these signals:

**Strong buying signals (they're likely ready):**
- They ask about timelines, start dates, or onboarding details
- They ask about contract or payment terms (logistics = intent)
- They say things like "when can we get started?" or "this looks great"
- They've stopped asking objection-type questions and are asking implementation questions
- They've looped in another person (a finance person, a manager) — they're building internal consensus

**Weak or absent signals (they're not ready yet):**
- They go quiet for days after receiving the proposal
- They keep asking about features or details but never move toward a decision
- They say "let me think about it" with no specific timeline
- They haven't responded to follow-ups

**Rule:** If you see strong signals, close. If you see weak or absent signals, don't push the close — address the underlying hesitation first.

---

## Step 2: The Close — Techniques and Scripts

Closing does not have to be high-pressure. For solopreneurs, the most effective closes are calm, confident, and make the next step obvious.

### Technique 1: The Assumptive Close
Act as if the deal is happening. State the next step as if it's already agreed upon.

```
"Great — I'll get the contract drafted with the terms we discussed and 
send it over this afternoon. Sound good?"
```
This works because it removes the awkward "so... do you want to do this?" moment. If they have a problem with the assumption, they'll say so — and that's useful information.

### Technique 2: The Summary Close
Recap everything you've agreed on, then name the action to finalize.

```
"To recap — we're moving forward with [scope], starting [date], at 
$[price] with [payment terms]. I'll send the contract and first invoice 
today. Anything you'd like to adjust before I do?"
```
Summaries build momentum. Hearing the terms restated — especially after a negotiation — creates a sense of forward motion.

### Technique 3: The Urgency Close (Use Honestly)
If there's a legitimate reason to act soon, state it. Do NOT manufacture fake urgency — solopreneurs live and die by trust.

```
"I want to flag — I have another project starting [date] that would 
affect my availability. If we kick off before then, I can give this 
my full focus. Otherwise, I'd need to push the start date to [later date]."
```
Only use this if it's true. Fake deadlines destroy credibility.

### Technique 4: The Trial Close
Test the waters before going for the full close. Lower the commitment, lower the resistance.

```
"Would it make sense to start with Phase 1 this week? That way you can 
see results before committing to the full engagement."
```
A phased start reduces the perceived risk. Many prospects who hesitate on a large commitment will say yes to a smaller first step — and then naturally continue.

---

## Step 3: Handle the "Let Me Think About It" Stall

This is the most common deal-killer for solopreneurs. "Let me think about it" usually means one of three things. Diagnose which one before responding.

### It means: "I have a concern I haven't voiced."
**How to tell:** They were engaged until a specific point, then pulled back. Or they avoid committing but haven't said no.
**Response:**
```
"Of course — I totally understand wanting to think it through. 
Before you do, is there anything specific that's giving you pause? 
I'd rather address it now than have it sit in the back of your mind."
```
Surface the real objection. Address it directly. Often, once it's named, it dissolves.

### It means: "The price feels high and I'm looking for permission to spend it."
**How to tell:** They liked everything about the proposal but hesitated specifically around price or payment.
**Response:**
```
"Totally fair. One thing that might help — [Company X] in a similar 
situation saw [specific result] within [timeframe]. The $[price] paid 
for itself in [X weeks/months]. Does that help frame it?"
```
Return to the ROI. Help them justify the spend internally — to themselves or to whoever they report to.

### It means: "I need to compare other options."
**How to tell:** They mentioned other vendors, or they haven't been responsive since the proposal.
**Response:**
```
"Smart to compare — I'd encourage that. If it helps, I'm happy to 
answer any specific questions that come up as you evaluate. And if 
you'd like, I can put together a quick comparison of what to look 
for in [this type of solution] so you're comparing apples to apples."
```
Don't badmouth competitors. Position yourself as the helpful advisor. Offering a "what to look for" guide keeps you in the conversation and subtly steers evaluation criteria toward your strengths.

---

## Step 4: Recover a Stalled Deal

Sometimes a deal goes cold — no response for a week or more. Here's how to bring it back without being annoying.

**Message 1 (Day 3-5 after last contact):**
```
"Hey [Name] — wanted to check in on [project/proposal]. Happy to 
answer any questions or jump on a quick call if that would help move 
things forward."
```
Simple. No pressure. Just a door left open.

**Message 2 (Day 7-10, different channel if possible):**
```
"One thought since we last spoke — [a new insight, a relevant case 
study, or a small piece of value]. Thought it might be useful as you 
think through this."
```
Lead with value, not a nudge. This re-engages the conversation on your terms.

**Message 3 (Day 14+, the breakup message):**
```
"Wanted to close the loop on this. I understand timing isn't always 
right, and that's completely fine. If things change down the road, 
I'd love to pick this up again. Best of luck either way."
```
The "breakup message" paradoxically has the highest response rate of the three. Giving them permission to walk away often makes them want to stay. If they don't respond, let it go — but leave the door open.

---

## Step 5: Contract to Payment — The Handoff

Once they say yes, move fast and make it frictionless. Slow or confusing handoffs lose deals that are already won.

**Checklist for the 24-48 hours after close:**

- [ ] Send the contract (use a signing tool: HelloSign, DocuSign, or even a simple PDF with e-signature). Include only what's necessary — scope, price, terms, start date, payment. Don't make them read a 20-page legal document.
- [ ] Send the first invoice (if upfront payment is required). Include clear payment instructions and a deadline.
- [ ] Send a warm welcome message: express genuine enthusiasm, restate what happens next, and set expectations for the first week.
- [ ] Calendar the kickoff. Even if it's a self-serve product, a brief kickoff call or onboarding email sets the tone for the relationship.

**Speed matters here.** Every hour between "yes" and "signed contract" is an hour where doubt can creep in. Make it easy and fast to formalize.

---

## Step 6: Set Up for Retention and Expansion

The deal isn't really "closed" until they've experienced value. Everything between signing and first value delivery is the danger zone for early churn.

**First 7 days post-close:**
- Deliver a quick win — something small that shows immediate results. This builds confidence that the larger promise will be kept.
- Over-communicate. Send a progress update even if there's nothing new to say. Silence feels like neglect to a new client.
- Ask one question: "Is there anything you need from me to make this work smoothly on your end?" This makes them feel like a partner, not just a customer.

**First 30 days post-close:**
- Check in once (not five times). Ask how things are going. Listen more than you talk.
- Identify the first natural upsell or expansion opportunity — but don't pitch it yet. Plant the seed: "Once we've nailed [Phase 1], there's a natural next step that could [outcome]. We can talk about that whenever you're ready."

---

## Closing Mistakes to Avoid
- Closing too early. If they're not ready, pushing the close creates resistance. Read the signals first.
- Closing too late. If they ARE ready and you keep having "just one more" conversations, you're burning their momentum and giving doubt time to grow.
- Apologizing for your price during the close. Confidence is contagious. If you believe in your price, they will too.
- Making the contract complicated. A simple, clear contract closes faster than a thorough but dense one. Cover the essentials; save the edge cases for if and when they matter.
- Disappearing after the signature. The close is the beginning of the relationship, not the end of the sales process. Treat it that way.
