#!/bin/bash
# clonev.sh - Voice cloning using Coqui XTTS v2
# SUPER SIMPLE - clone your voice and generate speech
# Usage: clonev.sh "Your text here" /path/to/voice_sample.wav [language]
# Languages: en, cs, de, fr, es, it, pl, pt, tr, ru, nl, ar, zh, ja, hu, ko

set -e

# Default values
TEXT="${1:-Hello, this is my cloned voice speaking}"
VOICE_SAMPLE="${2:-/samples/user_voice_sample.wav}"
LANG="${3:-en}"

# Configuration
COQUI_DIR="/mnt/c/TEMP/Docker-containers/coqui-tts"
OUTPUT_WAV="${COQUI_DIR}/output/clonev_output.wav"
OUTPUT_OGG="${COQUI_DIR}/output/clonev_output.ogg"

# Handle spaces in filename - copy to samples directory
SAMPLE_BASENAME=$(basename "$VOICE_SAMPLE")
if [ ! -f "${COQUI_DIR}/voice-samples/${SAMPLE_BASENAME}" ]; then
    cp "$VOICE_SAMPLE" "${COQUI_DIR}/voice-samples/"
fi

CONTAINER_SAMPLE_PATH="/samples/${SAMPLE_BASENAME}"

echo "> Cloning voice with XTTS v2..." >&2
echo "> Text: ${TEXT:0:50}..." >&2
echo "> Voice sample: ${SAMPLE_BASENAME}" >&2
echo "> Language: $LANG" >&2

# Run XTTS voice cloning
docker run --rm --entrypoint "" \
  -v "${COQUI_DIR}/models-xtts:/root/.local/share/tts" \
  -v "${COQUI_DIR}/voice-samples:/samples" \
  -v "${COQUI_DIR}/output:/output" \
  ghcr.io/coqui-ai/tts:latest \
  tts --model_name tts_models/multilingual/multi-dataset/xtts_v2 \
      --text "$TEXT" \
      --speaker_wav "$CONTAINER_SAMPLE_PATH" \
      --language_idx "$LANG" \
      --out_path /output/clonev_output.wav >&2

# Convert to OGG for Telegram
ffmpeg -y -i "$OUTPUT_WAV" -c:a libopus -b:a 24k -vn "$OUTPUT_OGG" 2>/dev/null

# Cleanup WAV
rm -f "$OUTPUT_WAV"

# Return OGG path
echo "$OUTPUT_OGG"
