# Corporate Governance

## Entity Management

### Formation Documents
- **Certificate of incorporation** — State filing, authorized shares, initial directors
- **Bylaws** — Operating rules, meeting procedures, officer roles
- **Stockholders agreement** — Voting, transfer restrictions, drag/tag rights
- **Voting agreement** — Board composition, protective provisions

### Ongoing Maintenance
- **Annual filings** — State franchise tax, annual report
- **Registered agent** — Maintained in state of incorporation and qualification states
- **Foreign qualification** — Register where doing business
- **Good standing** — Certificates for transactions, audits

## Board Operations

### Meeting Cadence
| Meeting Type | Frequency | Participants |
|--------------|-----------|--------------|
| Board meetings | Quarterly minimum | Directors, invited officers |
| Committee meetings | As needed | Committee members |
| Stockholder meetings | Annual minimum | All stockholders |
| Board consents | As needed | Directors (written) |

### Meeting Requirements
- **Notice** — Per bylaws, typically 3-10 days
- **Quorum** — Majority unless otherwise specified
- **Minutes** — Contemporaneous, approved at next meeting
- **Resolutions** — Formal approval of significant actions

### Board Committees (Public/Late-Stage)
- **Audit** — Financial oversight, external auditors, internal controls
- **Compensation** — Executive pay, equity grants, benchmarking
- **Nominating/Governance** — Board composition, director evaluation
- **Special** — M&A, litigation, investigations

## Equity Administration

### Cap Table Management
- **Authorized shares** — Track vs issued, reserve for option pool
- **Issued and outstanding** — Certificates or book entry
- **Options/warrants** — Vesting schedules, exercise tracking, expiration
- **Convertible instruments** — SAFEs, notes, conversion triggers

### Stock Issuances
1. **Board approval** — Resolution authorizing issuance
2. **Securities compliance** — Exemption verification (typically Reg D 506(b/c))
3. **Subscription/purchase agreement** — Terms, reps, warranties
4. **Accredited investor verification** — Questionnaire, third-party verification for 506(c)
5. **Legend** — Restricted securities notice on certificates/records

### Option Administration
- **Grant process** — Board approval, option agreement, 409A valuation
- **Vesting** — Track cliff, monthly/quarterly vesting, acceleration triggers
- **Exercise** — Payment methods, tax withholding, early exercise
- **Termination** — Post-termination exercise period, forfeiture

## Fiduciary Duties

### Director Duties
- **Care** — Informed decision-making, reasonable diligence
- **Loyalty** — Company's interest over personal, disclose conflicts
- **Good faith** — Act honestly, not for improper purpose
- **Business judgment rule** — Deference to reasonable, informed decisions

### Conflict Management
1. **Disclosure** — Full, to disinterested directors
2. **Recusal** — From discussion and vote on conflicted matters
3. **Approval** — By disinterested directors or stockholders
4. **Documentation** — Minutes reflecting process followed

## Key Documents Checklist

### Always Current
- [ ] Certificate of incorporation and amendments
- [ ] Bylaws (current version)
- [ ] Stockholders agreement
- [ ] Board and stockholder meeting minutes
- [ ] Stock ledger and cap table
- [ ] Option plan and grant records

### Transaction-Ready
- [ ] Good standing certificates
- [ ] Secretary's certificate
- [ ] Incumbency certificate
- [ ] Officer and director list
- [ ] Organizational chart
- [ ] Material contracts list
