# Contracts and Negotiations

## Contract Lifecycle

### Pre-Signature
1. **Request intake** — Who needs what, by when, business context
2. **Template selection** — Standard vs custom, risk level assessment
3. **Drafting/review** — Internal first, minimize external counsel for routine
4. **Negotiation** — Track redlines, know your walk-aways, escalation thresholds
5. **Approval workflow** — Who signs at what dollar threshold

### Post-Signature
1. **Execution** — Signature collection, counterpart management
2. **Storage** — Central repository, searchable, version controlled
3. **Obligation tracking** — Renewal dates, notice periods, deliverables
4. **Amendment management** — Keep history, restate for clarity
5. **Termination** — Exit provisions, transition assistance, return of data

## Negotiation Playbook

### Must-Have Terms
- Clear scope and deliverables
- Payment terms and penalties
- Limitation of liability (capped, mutual)
- Termination rights (for cause, for convenience)
- IP ownership clarity
- Confidentiality with reasonable exceptions
- Governing law and dispute resolution

### Red Flags to Escalate
- Unlimited liability
- Indemnification without caps
- Broad IP assignment beyond scope
- Perpetual exclusivity
- Audit rights without notice
- Unilateral modification rights
- Auto-renewal without opt-out

### Negotiation Tactics
- **Start with standard** — Deviation requires justification
- **Trade, don't concede** — Every give needs a get
- **Bracketing** — Anchor high/low, meet in middle
- **Silence is power** — Let them fill uncomfortable gaps
- **Written over verbal** — Confirm every agreement in email

## Contract Types

### Customer Agreements
- **SaaS/subscription** — ARR basis, usage limits, SLA, data handling
- **Enterprise** — Custom terms, security exhibits, audit rights
- **SMB** — Click-through, minimal negotiation, volume focus

### Vendor Contracts
- **Software** — License vs subscription, audit rights, support levels
- **Services** — SOW, acceptance criteria, change orders
- **Data** — DPA required, subprocessor management, breach notification

### Partnership Agreements
- **Strategic** — Exclusivity terms, revenue share, IP co-development
- **Channel** — Commission structure, lead routing, branding
- **Integration** — API terms, uptime commitments, version support

## Metrics

| Metric | Target |
|--------|--------|
| Turnaround time (standard) | < 3 days |
| Turnaround time (custom) | < 10 days |
| Contracts per legal FTE | 50-100/month |
| Outside counsel % of total | < 20% by volume |
| Renewal capture rate | > 95% tracked |
