# Compliance and Regulatory

## Privacy Regulations

### GDPR (EU)
- **Scope** — EU residents' personal data, regardless of company location
- **Key requirements** — Lawful basis, DPO if required, DPIA for high risk, 72h breach notification
- **Rights** — Access, rectification, erasure, portability, objection
- **Penalties** — Up to €20M or 4% global revenue

### CCPA/CPRA (California)
- **Scope** — California residents, companies meeting thresholds
- **Key requirements** — Privacy notice, opt-out rights, do not sell toggle
- **Rights** — Know, delete, correct, opt-out, limit sensitive data
- **Penalties** — $2,500-7,500 per intentional violation

### Other Privacy Laws
- **LGPD (Brazil)** — GDPR-like, DPO required
- **PIPL (China)** — Data localization, consent-heavy
- **POPIA (South Africa)** — Registration with regulator
- **State laws (US)** — Virginia, Colorado, Connecticut, Utah following CCPA model

## Industry Compliance

### SOC 2
- **Type 1** — Point-in-time control design
- **Type 2** — Operating effectiveness over period (6-12 months)
- **Trust principles** — Security, availability, processing integrity, confidentiality, privacy
- **Timeline** — 3-6 months readiness, 3-12 months audit period

### HIPAA (Healthcare)
- **Covered entities** — Healthcare providers, plans, clearinghouses
- **Business associates** — BAA required for all vendors handling PHI
- **Safeguards** — Administrative, physical, technical
- **Breach notification** — 60 days to HHS, individuals

### PCI DSS (Payment Cards)
- **Levels** — Based on transaction volume
- **SAQ vs ROC** — Self-assessment vs external audit
- **Key controls** — Network segmentation, encryption, access control
- **Annual validation** — Plus quarterly scans for some levels

### Financial Services
- **SOX** — Internal controls for public companies
- **GLBA** — Consumer financial privacy
- **AML/KYC** — Customer identification, suspicious activity reporting

## Compliance Program Components

### Foundation
1. **Risk assessment** — Annual, documented, prioritized
2. **Policies and procedures** — Written, accessible, version controlled
3. **Training** — Role-based, annual refresh, tracked completion
4. **Monitoring** — Controls testing, exception tracking

### Ongoing Operations
1. **Vendor management** — Due diligence, contractual requirements, monitoring
2. **Incident response** — Documented plan, tested annually, contact lists current
3. **Audit support** — Evidence collection, finding remediation, trend analysis
4. **Regulatory monitoring** — New laws, enforcement actions, industry guidance

## Audit Preparation

### 90 Days Before
- [ ] Confirm scope and timeline
- [ ] Identify control owners
- [ ] Pre-audit self-assessment
- [ ] Remediate known gaps

### 30 Days Before
- [ ] Evidence collection dry run
- [ ] Brief control owners on process
- [ ] Prepare management representation letter
- [ ] Schedule auditor logistics

### During Audit
- [ ] Single point of contact for auditors
- [ ] Document all requests and responses
- [ ] Escalate findings immediately
- [ ] Daily status sync with leadership
