# Client Retention — Keep Clients Paying Monthly

Turn one-time projects into recurring revenue and reduce churn. The cheapest client to acquire is the one you already have.
Sources: SerpSculpt (B2B retention stats 2025), Breakthrough3x (recurring revenue models), Recurly (churn data), Outreach.io, AvidTrak.
All outputs go to `workspace/artifacts/`.

## Use when
- Designing a recurring revenue model (retainers, subscriptions, managed services)
- A client's renewal is coming up and you want to ensure they stay
- Building onboarding flows for new clients (first 30 days = highest churn risk)
- Analyzing why clients leave and building prevention systems
- Planning upsells or expansion revenue from existing clients
- Structuring service tiers to maximize lifetime value

## Don't use when
- Acquiring new clients (use cold-outreach, lead-magnets, client-discovery)
- Client has already churned and you're trying to win them back (different playbook — winback campaigns)
- One-time product sales with no recurring component
- The client is genuinely a bad fit (let them go gracefully)

## Negative examples
- "Help me find new clients" → No. This is about keeping existing ones.
- "Write a cold email" → No. Use cold-outreach skill.
- "A client is angry" → Borderline. If it's a churn risk, yes. If it's a support ticket, handle the ticket first.

## Edge cases
- Converting a one-time Upwork project into ongoing retainer → YES. This is the highest-value retention play.
- Client asks to pause service → YES. Pause management prevents full churn.
- Client wants to downgrade tier → YES. Downgrade retention is better than full churn.

---

## Why Retention > Acquisition

**The math:**
- Acquiring a new client costs 5-7x more than retaining an existing one
- Increasing retention by 5% increases profits by 25-95% (Bain & Co, widely cited)
- Business consulting firms average 83-85% annual retention (SerpSculpt 2025)
- Top SaaS performers push NRR (Net Revenue Retention) past 120% — meaning existing clients PAY MORE over time

**For our $2,000 goal:** One client at $149/mo = $1,788/year. Keeping them for 12 months is worth more than acquiring 3 clients who churn after 2 months each.

---

## The 4 Pillars of Client Retention

### Pillar 1: Onboarding (First 30 Days = Make or Break)

**20%+ of voluntary churn is linked to poor onboarding** (Recurly). The first 30 days set the trajectory.

**Onboarding checklist:**
- [ ] **Day 1**: Welcome message + clear expectations (what happens when, what they need to do)
- [ ] **Day 1-3**: Setup/implementation begins (show immediate progress)
- [ ] **Day 7**: First check-in — "How's it going? Any questions?"
- [ ] **Day 14**: First measurable result shared ("Here's what's happened so far")
- [ ] **Day 30**: Full review — show ROI, confirm value, discuss next steps

**Key principle:** Get them a quick win FAST. The sooner they see value, the stickier they become.

**For Alfred:** Day 1 = SMS auto-responder active. Day 7 = first auto-booked appointment. Day 14 = share stats (X messages handled, Y bookings captured).

### Pillar 2: Ongoing Value Delivery (Monthly Proof)

Clients don't churn because your service stopped working. They churn because they forgot it was working.

**Monthly value report (automated):**
```
Hi [Client],

Here's your [Month] recap:
- [Metric 1]: X (up Y% from last month)
- [Metric 2]: Z
- Total value delivered: $[amount]
- Your investment: $[price]
- ROI: [X]x

Anything you'd like to adjust for next month?
```

**Rules:**
- Send this EVERY month without fail (automate it)
- Show real numbers, not vague "things are going well"
- Always end with a question (keeps the conversation open)
- Highlight one thing you improved or optimized (shows you're actively working)

### Pillar 3: Proactive Check-Ins (Quarterly Business Reviews)

Don't wait for problems. Surface them before they become churn.

**Quarterly check-in framework:**
1. "What's working well?" (reinforce value)
2. "What could be better?" (surface issues early)
3. "What's changed in your business since we started?" (spot expansion opportunities)
4. "Are there other areas where we could help?" (upsell naturally)

**Churn signals to watch:**
- Usage drops (they're not using the service)
- Response times slow (they're disengaging)
- They ask about contract terms or cancellation (actively considering leaving)
- A key contact leaves the company (relationship risk)
- They stop responding to check-ins (silent churn incoming)

### Pillar 4: Expansion Revenue (Upsells That Feel Natural)

The best retention strategy is making the client MORE successful over time, which naturally leads to them wanting more.

**Expansion revenue models:**
- **Tier upgrades:** "You've maxed out the Growth plan. Scale unlocks [features]."
- **Add-on services:** "Based on your results, [new service] could add another $X/mo."
- **Volume expansion:** "You're handling 200 messages/mo now. At 500+, the Premium tier makes more sense."
- **Referral incentives:** "Know another [business type]? We'll give you a month free for referrals."

**Top B2B SaaS performers generate 50%+ of new ARR from upsells** (SerpSculpt). This means half their growth comes from existing clients, not new ones.

---

## Recurring Revenue Models

| Model | Best For | Example |
|-------|----------|---------|
| Monthly retainer | Ongoing managed service | Alfred SMS automation at $149/mo |
| Subscription tiers | Productized service | Basic/Growth/Scale pricing |
| Usage-based | Variable demand | Per-message, per-booking pricing |
| Annual contract (discounted) | Cash flow stability | $149/mo or $1,490/year (save 17%) |
| Retainer + project | Hybrid | Base retainer + one-off builds as needed |

**Best practice:** Start with monthly, no long-term commitment. Once they see value (month 2-3), offer annual at a discount. This locks in revenue AND signals their commitment.

---

## Churn Prevention Playbook

**When you detect a churn signal:**

1. **Reach out immediately** — Don't wait. "Hey [name], noticed [signal]. Everything okay?"
2. **Listen first** — Don't defend. Understand what changed.
3. **Offer solutions** — Tier adjustment, pause, scope change — anything beats full cancellation.
4. **Quantify what they'll lose** — "Over the last 3 months, the system captured $X in bookings for you."
5. **If they still want to leave** — Be gracious. "Totally understand. We're here if things change. Can I ask what we could have done better?" (This feedback is gold.)

**Pause > Cancel:** Always offer a pause option (1-2 months) before cancellation. Many "I want to cancel" clients just need a breather.

---

## Key Numbers
- New client acquisition costs 5-7x more than retention
- 5% retention increase → 25-95% profit increase (Bain & Co)
- 20%+ of voluntary churn linked to poor onboarding (Recurly)
- Business consulting average retention: 83-85% annually
- Top performers: NRR >120% (clients pay more over time)
- 50%+ of growth at top companies comes from existing client expansion
- First 30 days = highest churn risk period
