# Client Discovery — Qualify, Diagnose, Close

Run discovery conversations that qualify prospects, diagnose real problems, and position your solution as the obvious next step.
Sources: Consulting Success (2026), Melisa Liberman (36 questions framework), Freelance Cake, HubSpot, Highspot.
All outputs go to `workspace/artifacts/`.

## Use when
- Preparing for a discovery call with a prospect
- Qualifying whether a lead is worth pursuing
- Drafting discovery questions for a specific industry/niche
- Reviewing notes from a call to identify next steps
- Writing a proposal based on discovery findings
- Evaluating client fit before committing to a project

## Don't use when
- Cold outreach (use cold-outreach skill — discovery comes AFTER they respond)
- Existing client check-ins (different dynamic — you already have context)
- Pricing decisions (use pricing-psychology skill)
- Building the actual deliverable (discovery is pre-build)

## Negative examples
- "Write me a proposal" → Borderline. Discovery must happen BEFORE the proposal. If you haven't done discovery, do that first.
- "Help me negotiate a rate" → No. That's pricing/negotiation, not discovery.
- "How do I find leads?" → No. That's lead generation, not qualification.

## Edge cases
- Upwork job evaluation → YES. Reading a job post IS discovery. Assess fit before bidding.
- Text/DM-based discovery → YES. Same principles apply, just compressed format.
- Qualifying yourself OUT of a bad fit → YES. The best outcome of discovery is sometimes "no."

---

## The Core Truth

**Peter Drucker**: "My greatest strength as a consultant is to be ignorant and ask a few questions."

Discovery is not a pitch meeting. You're not there to impress — you're there to **diagnose**. The moment you start talking about your solution before understanding their problem, you've lost.

### The 80/20 Rule (Melisa Liberman)
- **Listen 80%** of the time. Talk 20%. (Aspirational target — the point is to listen far more than you talk, even if exact ratios vary.)
- When you do talk, ask questions — don't monologue.
- Be comfortable with silence. Ask, then wait. Even if it's uncomfortable.
- The prospect should feel heard, not sold to.

### Why This Matters for Revenue
Freelance Cake's Austin Church: "Insightful questions testify to your competence more than your clever monologues." Asking the right questions often **increases project scope** — a prospect willing to pay $2,500 for a plan may happily pay $2,500/month for a retainer when you uncover the real problem.

---

## The Discovery Framework: 5 Phases

### Phase 1: Context (Warm-Up)
**Goal:** Understand who they are and what's happening now.

Questions:
1. "Tell me about your business — what do you do and who do you serve?"
2. "How did you hear about us?" (reveals channel effectiveness)
3. "What prompted you to reach out now?" (reveals urgency trigger)
4. "What does a typical day/week look like for you?" (reveals workflow)

**Listen for:** Scale, team size, current tools, immediate triggers.

### Phase 2: Problem Diagnosis
**Goal:** Uncover the REAL problem (often not what they initially say).

Questions:
5. "What's the biggest challenge you're facing right now?"
6. "How long has this been a problem?" (reveals severity)
7. "What have you tried so far to fix it?" (reveals what didn't work)
8. "What happens if you don't solve this?" (reveals cost of inaction)
9. "Who else is affected by this problem?" (reveals stakeholders)
10. "On a scale of 1-10, how urgent is this?" (forces prioritization)

**Listen for:** Pain level, failed attempts (so you don't repeat them), who owns the decision.

**Key technique (Freelance Cake):** Push past symptoms to root causes. "My website doesn't convert" might really be "I have no positioning" or "I'm targeting the wrong audience." Keep asking "why" until you hit bedrock.

### Phase 3: Desired Outcome
**Goal:** Define what success looks like in their words.

Questions:
11. "If we solve this perfectly, what does that look like 6 months from now?"
12. "What metrics would tell you this is working?" (quantifies success)
13. "What would change in your daily life if this was fixed?" (emotional anchor)
14. "Have you seen anyone do this well? What impressed you?" (reveals expectations)

**Listen for:** Specific numbers, emotional language, reference points.

### Phase 4: Qualification (Fit Check)
**Goal:** Determine if you can actually help AND if they can actually pay.

Questions:
15. "Do you have a budget range in mind for this?" (direct but necessary)
16. "Who else needs to approve this decision?" (reveals decision chain)
17. "What's your timeline for getting this done?" (reveals urgency vs. browsing)
18. "What would make you confident enough to move forward?" (reveals objections early)

**Disqualification signals (walk away):**
- No budget and no timeline → "just exploring"
- Decision requires 5+ approvals → bureaucratic nightmare
- They want a $10K solution for $500 → misaligned expectations
- They've fired 3 previous consultants → the problem might be them
- They can't articulate what success looks like → unclear scope = scope creep
- Resistance to sharing information or collaborating openly
- No clear goals or priorities beyond "make it better"

### Phase 5: Bridge to Proposal
**Goal:** Summarize what you heard, confirm alignment, set next steps.

19. "Let me make sure I have this right..." (summarize their problem, desired outcome, and constraints)
20. "Based on what you've shared, here's what I think we should do..." (brief, directional)
21. "What questions do you have for me?" (give them the floor)
22. "What's the best next step from here?" (let them tell you)

**Never end a discovery call without:** A clear next step with a date. "I'll send a proposal by Friday" or "Let's schedule a follow-up for Tuesday."

---

## Red Flags & Green Flags

### 🟢 Green Flags (good fit)
- They can articulate the problem clearly
- They have a budget and timeline
- They've tried solutions before (means they take it seriously)
- Single decision-maker or clear decision process
- They ask smart questions back
- Urgency is real ("this is costing us $X/month")

### 🔴 Red Flags (proceed with caution or decline)
- "Can you just give me a quick quote?" (no discovery = bad project)
- "We need this by tomorrow" (unrealistic unless premium pricing)
- "Our last 3 vendors couldn't do this" (the problem may not be the vendors)
- Scope keeps expanding during the call with no budget increase
- They won't answer budget questions at all
- "We'll figure out the details later" (scope creep incoming)
- They want you to "prove yourself" with free work first

---

## Upwork-Specific Discovery

When evaluating Upwork jobs, run a mini-discovery on the posting itself:

**Read the post and answer:**
1. Is the problem clearly defined? (Green flag)
2. Is the budget realistic for the scope? (Check range)
3. How many proposals submitted? (<10 = good opportunity)
4. Is the client verified with payment history? (Green flag)
5. Can I deliver this with existing skills/tools? (Fit check)
6. Is there a follow-up opportunity beyond this project? (Revenue potential)

**In your proposal, demonstrate discovery:**
- Reference their specific problem (proves you read it)
- Ask 1-2 clarifying questions (shows you think before building)
- Propose a scope that matches their budget (not your wishlist)

---

## Post-Discovery: The Problem Statement

After every discovery call, write a 2-3 sentence problem statement:

```
[Client name] is a [business type] struggling with [specific problem].
This is costing them [quantified impact: money, time, customers].
They need [solution category] by [timeline] with a budget of [range].
```

This becomes the foundation of your proposal. If you can't write this clearly, you need another discovery conversation.

---

## Common Mistakes (Consulting Success + Liberman)

1. **Talking too much** — You're not pitching, you're diagnosing.
2. **Treating it like a job interview** — You're a peer consultant, not an applicant.
3. **Trying to prove yourself** — Curiosity builds more trust than credentials.
4. **Skipping the budget question** — If you don't ask, you'll waste time on proposals they can't afford.
5. **Writing proposals for uncommitted prospects** — No proposal until you've confirmed budget, timeline, and decision-maker.
6. **Not taking notes** — Write everything down. Review before writing the proposal.
7. **Rushing to solution mode** — Sit with the problem longer. The real issue is usually 2-3 layers deeper than what they first say.
